export const RegisterBgPattern: React.FC<React.SVGAttributes<{}>> = (props) => {
  return (
    <svg
      width="1031"
      height="467"
      viewBox="0 0 1031 467"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      {...props}
    >
      <g opacity="0.15">
        <path
          d="M445.165 -19.6714C439.895 -7.9648 434.716 3.7872 429.174 15.3577C426.403 21.1656 423.541 26.8827 420.361 32.4638C418.771 35.2316 417.09 37.9995 415.318 40.6312C413.547 43.2629 411.593 45.8493 409.413 48.2087L408.595 49.0708L407.732 49.9329C407.187 50.5228 406.551 51.0219 405.96 51.5664C404.734 52.5646 403.507 53.5629 402.144 54.425C399.464 56.1038 396.466 57.3289 393.377 57.9642L392.786 58.1003L392.196 58.1911C391.787 58.2364 391.423 58.3272 391.014 58.3726C390.242 58.4633 389.425 58.5541 388.652 58.5541C387.062 58.6448 385.472 58.5541 383.882 58.4633C380.702 58.1911 377.568 57.6012 374.479 56.8752C368.255 55.3779 362.213 53.1999 356.262 50.9312C350.311 48.6171 344.405 46.1215 338.5 43.5351C326.734 38.4078 315.059 33.099 303.384 27.8356L268.314 12.0453L198.082 -19.626L197.355 -17.9471L267.723 13.225L302.93 28.7885C314.65 33.9612 326.371 39.2246 338.182 44.2611C344.087 46.8021 349.993 49.2523 355.99 51.5664C361.986 53.8351 368.073 55.9677 374.342 57.4651C377.477 58.1911 380.657 58.7809 383.882 59.0078C385.472 59.0985 387.108 59.1893 388.743 59.0986C389.561 59.0986 390.333 58.9624 391.151 58.9171C391.56 58.8717 391.968 58.7809 392.332 58.7356L392.922 58.6448L393.513 58.5087C396.693 57.8734 399.737 56.603 402.462 54.8787C403.825 54.0166 405.097 53.0184 406.324 51.9748C406.914 51.4303 407.55 50.8858 408.095 50.3413L408.959 49.4792L409.776 48.5717C411.957 46.2122 413.865 43.5805 415.682 40.9488C417.454 38.2717 419.134 35.5039 420.679 32.6907C423.813 27.0642 426.63 21.3017 429.401 15.4938C434.852 3.83254 439.986 -7.91942 445.165 -19.6714Z"
          fill="#919191"
        />
        <path
          d="M457.112 -19.2629C451.252 -6.28581 445.528 6.73664 439.531 19.6683C436.488 26.1115 433.444 32.5092 430.037 38.7709C428.356 41.9017 426.584 44.9872 424.631 47.9819C422.723 50.9766 420.633 53.8805 418.316 56.5576C418.044 56.8752 417.726 57.2382 417.453 57.5558L416.545 58.5087C415.909 59.1439 415.318 59.7792 414.637 60.3237C414.001 60.9135 413.274 61.458 412.593 62.0479C411.866 62.547 411.184 63.0915 410.412 63.5452C408.913 64.4981 407.368 65.3148 405.733 65.9501C404.097 66.5853 402.371 67.039 400.645 67.402C398.919 67.7197 397.147 67.8558 395.375 67.8558C393.604 67.8558 391.832 67.7197 390.106 67.5382C386.608 67.1298 383.11 66.3585 379.703 65.4056C372.889 63.4999 366.211 61.0043 359.624 58.3272C353.037 55.6501 346.54 52.8369 340.044 49.9329C327.052 44.1704 314.105 38.3171 301.112 32.4638L262.181 14.9494L184.408 -19.9888L183.681 -18.31L261.681 16.2652L300.704 33.5528C313.696 39.3154 326.688 45.1233 339.726 50.7951C346.268 53.6536 352.764 56.4215 359.396 59.0986C366.029 61.7303 372.707 64.2259 379.566 66.0862C383.019 66.9937 386.517 67.765 390.06 68.1734C391.832 68.3549 393.649 68.491 395.421 68.4457C397.192 68.4003 399.01 68.2642 400.781 67.9465C402.553 67.6289 404.279 67.1298 405.96 66.4492C407.641 65.814 409.231 64.9518 410.73 63.9536C411.502 63.4999 412.184 62.91 412.911 62.4109C413.592 61.821 414.319 61.2765 414.955 60.6867C415.636 60.0968 416.227 59.4616 416.863 58.8263L417.771 57.8281C418.089 57.5105 418.362 57.1475 418.68 56.8298C420.997 54.1074 423.086 51.2035 424.994 48.2088C426.902 45.214 428.674 42.0832 430.355 38.9524C433.716 32.6907 436.76 26.2476 439.758 19.759C445.664 6.82736 451.343 -6.24043 457.112 -19.2629Z"
          fill="#919191"
        />
        <path
          d="M469.423 -19.7166L459.838 1.6547C456.658 8.77847 453.478 15.9022 450.207 22.9806C446.937 30.059 443.62 37.1374 440.077 44.0797C438.305 47.5281 436.397 50.9766 434.398 54.2889C432.4 57.6012 430.264 60.8682 427.811 63.9083C426.63 65.451 425.313 66.903 423.95 68.2642C422.587 69.6255 421.133 70.8959 419.544 72.0303C416.409 74.2536 412.82 75.8871 409.004 76.6131C405.188 77.3391 401.282 77.2937 397.466 76.7492C393.604 76.2501 389.834 75.3426 386.109 74.2537C378.658 72.0757 371.39 69.2171 364.212 66.2224C357.035 63.2277 349.903 60.0969 342.77 56.9207L172.098 -19.762L171.371 -18.0831L342.407 57.7828C349.539 60.9136 356.717 64.0444 363.894 66.9938C371.117 69.9431 378.386 72.7563 385.927 74.9343C389.697 76.0233 393.513 76.8853 397.42 77.3845C401.282 77.8836 405.279 77.929 409.141 77.1576C413.002 76.4316 416.682 74.7528 419.862 72.4387C421.451 71.3043 422.951 69.9885 424.313 68.5819C425.676 67.1753 426.994 65.7233 428.175 64.1805C430.628 61.0951 432.718 57.8281 434.716 54.4704C436.715 51.1127 438.578 47.6643 440.349 44.2158C443.893 37.2736 447.164 30.1952 450.389 23.0714C453.614 15.9476 456.749 8.82389 459.929 1.70012L469.423 -19.7166Z"
          fill="#919191"
        />
        <path
          d="M481.552 -19.7166L460.701 26.7921C457.203 34.5057 453.659 42.2647 449.843 49.8422C447.935 53.6537 445.982 57.4197 443.847 61.0951C441.712 64.7704 439.486 68.4003 436.942 71.758C434.398 75.1611 431.536 78.2919 428.22 80.8783C426.539 82.1487 424.722 83.2377 422.814 84.0998C420.906 84.962 418.862 85.5972 416.817 85.9602C412.683 86.7315 408.413 86.5501 404.234 85.9148C400.054 85.2796 395.966 84.1906 391.923 82.9655C383.837 80.4245 375.978 77.2483 368.164 73.936C360.35 70.6237 352.628 67.1752 344.859 63.6814L159.105 -19.762L158.378 -18.0831L344.496 64.4981C352.264 67.9466 360.032 71.3496 367.846 74.662C375.66 77.9289 383.564 81.1051 391.696 83.6007C395.739 84.8712 399.918 85.9148 404.097 86.55C408.322 87.1399 412.638 87.3214 416.863 86.5047C418.952 86.0963 421.042 85.4611 422.995 84.5536C424.949 83.6461 426.766 82.5117 428.492 81.2412C431.899 78.6095 434.761 75.4333 437.305 71.9849C439.849 68.5818 442.075 64.9519 444.165 61.2312C446.254 57.5559 448.208 53.7444 450.116 49.933C453.886 42.3101 457.384 34.5964 460.837 26.8374L481.552 -19.7166Z"
          fill="#919191"
        />
        <path
          d="M493.318 -18.9907L470.786 31.2387C467.016 39.5876 463.245 47.9365 459.202 56.1946C457.203 60.3237 455.114 64.4074 452.888 68.4003C450.662 72.3933 448.299 76.3408 445.619 80.0615C442.939 83.7369 439.941 87.2307 436.306 90.0439C434.489 91.4505 432.536 92.6302 430.492 93.5377C428.402 94.4452 426.221 95.0805 423.995 95.4435C419.498 96.1694 414.91 95.8065 410.412 94.9897C405.915 94.173 401.509 92.9025 397.193 91.4505C392.832 89.9985 388.562 88.365 384.337 86.6862C380.112 84.962 375.887 83.1924 371.662 81.3774C363.258 77.7475 354.9 73.9814 346.541 70.2153L145.931 -19.8528L145.204 -18.1739L346.177 71.0774C354.536 74.7981 362.94 78.5188 371.344 82.1034C375.569 83.9184 379.794 85.6879 384.064 87.3668C388.335 89.0456 392.605 90.6791 396.966 92.0857C401.327 93.5377 405.779 94.7628 410.276 95.5796C414.819 96.3963 419.453 96.7139 424.041 95.9879C426.312 95.6249 428.584 94.9897 430.673 94.0368C432.808 93.084 434.762 91.8589 436.579 90.4523C440.213 87.5937 443.257 84.0545 445.937 80.3338C448.617 76.5677 450.98 72.6201 453.16 68.6272C455.386 64.5889 457.43 60.5052 459.429 56.3761C463.427 48.118 467.152 39.7237 470.877 31.3748L493.318 -18.9907Z"
          fill="#919191"
        />
        <path
          d="M505.902 -19.9889L481.689 34.0519C477.646 43.0814 473.602 52.0656 469.378 61.0043C467.243 65.451 465.062 69.8977 462.791 74.2536C460.474 78.6096 458.021 82.9201 455.295 87.0038C452.524 91.0875 449.48 94.9897 445.755 98.1659C443.893 99.754 441.848 101.161 439.668 102.25C437.487 103.339 435.171 104.11 432.763 104.564C427.947 105.471 422.996 105.063 418.181 104.155C413.365 103.248 408.641 101.841 403.962 100.253C394.649 97.0316 385.563 93.1747 376.523 89.2272C367.483 85.2796 358.488 81.2413 349.494 77.203L133.575 -19.7167L132.848 -18.0378L349.176 78.0651C358.17 82.058 367.21 86.0963 376.251 89.9985C385.291 93.9007 394.422 97.7575 403.78 100.934C408.459 102.522 413.229 103.883 418.09 104.791C422.95 105.653 427.993 106.061 432.899 105.108C435.352 104.654 437.715 103.838 439.94 102.703C442.166 101.569 444.211 100.162 446.119 98.5289C449.889 95.262 452.933 91.3144 455.704 87.2307C458.43 83.1016 460.883 78.7911 463.2 74.4351C465.516 70.0792 467.651 65.6325 469.741 61.1404C473.966 52.2017 477.918 43.1722 481.961 34.1427L505.902 -19.9889Z"
          fill="#919191"
        />
        <path
          d="M517.94 -19.8073L492.001 38.0449C487.685 47.7097 483.415 57.329 478.917 66.903C476.692 71.6673 474.375 76.4316 471.967 81.1505C469.559 85.8241 466.97 90.4523 464.153 94.8989C461.291 99.3003 458.066 103.565 454.159 107.059C450.298 110.598 445.483 113.094 440.304 113.911C435.125 114.773 429.81 114.228 424.677 113.185C422.087 112.64 419.543 111.96 417.045 111.234C414.546 110.462 412.048 109.646 409.549 108.738C399.646 105.154 389.97 100.934 380.294 96.7139C370.617 92.4487 361.032 88.0928 351.401 83.7822L120.219 -19.9435L119.492 -18.2646L351.038 84.6443C360.669 88.9095 370.345 93.2201 380.021 97.4853C389.697 101.705 399.419 105.88 409.367 109.419C411.866 110.281 414.365 111.143 416.908 111.869C419.452 112.595 421.996 113.276 424.586 113.82C429.765 114.864 435.125 115.408 440.44 114.501C443.075 114.047 445.619 113.185 447.981 112.005C450.389 110.825 452.569 109.237 454.523 107.468C458.475 103.928 461.7 99.6179 464.562 95.1712C467.424 90.7245 469.968 86.051 472.376 81.3774C474.784 76.6585 477.055 71.8942 479.281 67.0845C483.733 57.5105 487.958 47.8004 492.273 38.1357L517.94 -19.8073Z"
          fill="#919191"
        />
        <path
          d="M529.796 -19.1721L502.222 42.3101C497.633 52.5647 493.091 62.8193 488.366 73.0285C486.004 78.1104 483.596 83.1923 481.098 88.2289C478.554 93.2201 475.919 98.1659 472.921 102.93C469.922 107.649 466.652 112.232 462.518 116.043C460.473 117.904 458.202 119.583 455.704 120.808L454.75 121.261C454.432 121.397 454.114 121.534 453.796 121.67C453.16 121.942 452.478 122.169 451.842 122.396C450.525 122.804 449.162 123.122 447.799 123.349C445.073 123.757 442.257 123.802 439.486 123.575C436.715 123.349 433.944 122.849 431.218 122.26C425.767 121.035 420.452 119.22 415.182 117.314C404.688 113.412 394.421 108.874 384.155 104.337L353.445 90.5884L107.817 -19.5804L107.09 -17.9016L353.127 91.4504L383.882 105.108C394.149 109.6 404.461 114.138 415 117.994C420.27 119.9 425.63 121.67 431.127 122.94C433.853 123.575 436.669 124.029 439.486 124.256C442.302 124.483 445.164 124.438 447.935 123.984C449.344 123.757 450.706 123.439 452.069 122.986C452.751 122.759 453.432 122.532 454.068 122.26C454.386 122.123 454.704 121.987 455.068 121.851L456.022 121.397C458.566 120.127 460.837 118.403 462.927 116.497C467.106 112.64 470.377 108.012 473.375 103.248C476.328 98.4835 478.963 93.4923 481.507 88.5011C484.005 83.4646 486.413 78.3826 488.73 73.3007C493.409 63.0915 497.906 52.7916 502.494 42.537L529.796 -19.1721Z"
          fill="#919191"
        />
        <path
          d="M542.108 -19.6259L512.807 45.7132C507.901 56.603 503.086 67.5382 498.134 78.3826C495.636 83.8276 493.137 89.2271 490.502 94.5813C487.867 99.9354 485.096 105.244 482.053 110.326C478.963 115.408 475.602 120.354 471.332 124.528C469.242 126.616 466.834 128.385 464.245 129.837C461.655 131.198 458.794 132.197 455.886 132.605C454.432 132.877 452.933 132.923 451.48 133.013C449.98 133.013 448.527 132.968 447.028 132.832C444.075 132.56 441.167 132.015 438.26 131.334C432.491 129.928 426.858 128.022 421.27 125.89C410.14 121.624 399.238 116.769 388.38 111.914L355.718 97.3037L94.5983 -19.8074L93.8714 -18.1285L355.354 98.1659L388.062 112.686C398.965 117.495 409.868 122.305 421.043 126.57C426.631 128.657 432.309 130.609 438.124 131.97C441.031 132.65 443.984 133.195 446.982 133.467C448.481 133.603 449.98 133.649 451.48 133.649C452.979 133.603 454.478 133.512 455.977 133.24C458.975 132.786 461.837 131.788 464.517 130.382C467.152 128.93 469.56 127.115 471.695 124.982C475.965 120.762 479.372 115.771 482.461 110.644C485.551 105.517 488.276 100.208 490.911 94.8535C493.546 89.4993 496.044 84.0544 498.497 78.6095C503.404 67.7197 508.219 56.7844 513.08 45.8946L542.108 -19.6259Z"
          fill="#919191"
        />
        <path
          d="M554.464 -20.125L523.437 49.0709L507.946 83.6461C505.356 89.4087 502.722 95.1258 499.951 100.843C497.179 106.515 494.363 112.187 491.183 117.631C489.593 120.354 487.912 123.031 486.14 125.617C484.323 128.204 482.37 130.654 480.189 132.923C478.009 135.146 475.556 137.188 472.83 138.731C472.149 139.139 471.467 139.457 470.74 139.82C470.377 140.001 470.014 140.137 469.65 140.273L469.105 140.5L468.56 140.682C467.106 141.226 465.562 141.589 464.017 141.861C462.473 142.134 460.928 142.224 459.338 142.27C457.793 142.27 456.204 142.224 454.659 142.043C451.524 141.725 448.435 141.135 445.392 140.364C439.304 138.821 433.353 136.689 427.448 134.42C421.587 132.151 415.773 129.701 409.958 127.16C404.189 124.665 398.419 122.078 392.65 119.492L358.079 104.019L81.6053 -19.9435L80.8784 -18.2646L357.716 104.881L392.332 120.263C398.101 122.804 403.871 125.391 409.685 127.886C415.5 130.382 421.315 132.832 427.221 135.101C433.126 137.369 439.077 139.457 445.255 140.999C448.344 141.771 451.434 142.361 454.614 142.678C456.204 142.86 457.793 142.905 459.383 142.86C460.973 142.814 462.563 142.724 464.153 142.406C465.698 142.134 467.288 141.771 468.787 141.181L469.332 140.999L469.877 140.772C470.241 140.636 470.604 140.455 470.968 140.319C471.694 139.956 472.421 139.638 473.103 139.23C475.874 137.642 478.327 135.554 480.553 133.286C482.779 131.017 484.732 128.476 486.549 125.89C488.366 123.303 490.047 120.581 491.592 117.858C494.772 112.368 497.588 106.696 500.314 101.025C503.04 95.3073 505.674 89.5902 508.264 83.8276L523.664 49.207L554.464 -20.125Z"
          fill="#919191"
        />
        <path
          d="M566.366 -19.6258L533.658 53.3814L517.304 89.9077C514.578 95.9879 511.807 102.068 508.945 108.057C506.083 114.092 503.085 120.036 499.814 125.844C496.498 131.607 492.909 137.279 488.321 142.088C486.004 144.448 483.46 146.626 480.553 148.214C477.691 149.847 474.511 150.845 471.24 151.299C469.604 151.526 467.969 151.617 466.288 151.571C465.47 151.571 464.653 151.526 463.79 151.481C462.972 151.39 462.154 151.345 461.336 151.208C458.066 150.8 454.795 150.074 451.615 149.212C445.21 147.442 438.941 145.128 432.762 142.678C426.584 140.228 420.451 137.596 414.364 134.919C408.277 132.242 402.189 129.52 396.102 126.797L359.623 110.462L67.8403 -20.3064L67.1135 -18.6276L359.26 111.324L395.784 127.568C401.871 130.291 407.959 132.968 414.092 135.645C420.224 138.322 426.312 140.908 432.535 143.359C438.759 145.809 445.028 148.123 451.479 149.847C454.704 150.709 457.975 151.435 461.291 151.844C462.109 151.98 462.972 152.025 463.79 152.071C464.607 152.116 465.47 152.161 466.288 152.161C467.969 152.207 469.65 152.071 471.331 151.844C474.647 151.39 477.918 150.301 480.825 148.667C483.778 147.034 486.367 144.856 488.684 142.451C493.272 137.551 496.907 131.879 500.177 126.071C503.448 120.263 506.401 114.274 509.263 108.239C512.125 102.204 514.851 96.124 517.576 90.0439L533.839 53.4722L566.366 -19.6258Z"
          fill="#919191"
        />
        <path
          d="M578.314 -19.2176L543.834 57.7827L526.572 96.2601C523.71 102.658 520.802 109.056 517.804 115.453C514.806 121.806 511.717 128.113 508.264 134.238C504.812 140.319 501.087 146.353 496.226 151.435C494.999 152.66 493.727 153.886 492.364 154.975C491.002 156.064 489.548 157.016 488.003 157.833C484.914 159.467 481.553 160.465 478.055 160.782C476.328 160.964 474.557 160.964 472.83 160.919C471.104 160.873 469.333 160.646 467.606 160.374C464.154 159.83 460.747 158.967 457.385 158.015C450.662 156.018 444.12 153.523 437.624 150.891C431.128 148.214 424.677 145.446 418.272 142.587L399.01 134.012L360.578 116.769L206.759 47.8457L129.85 13.3612L91.418 -3.88103L72.1566 -12.4568C65.7513 -15.3154 59.3005 -18.1285 52.7589 -20.7603L52.0775 -19.0814C58.5737 -16.4497 65.0244 -13.6365 71.4298 -10.8233L90.6912 -2.29292L129.214 14.8586L206.26 48.9801L360.26 117.495L398.783 134.647L418.044 143.177C424.495 145.99 430.946 148.804 437.442 151.435C443.938 154.067 450.525 156.563 457.294 158.559C460.656 159.557 464.108 160.374 467.606 160.919C469.333 161.145 471.104 161.372 472.876 161.463C474.648 161.554 476.419 161.508 478.191 161.327C481.734 161.009 485.187 159.966 488.321 158.287C489.866 157.425 491.365 156.472 492.773 155.383C494.182 154.294 495.454 153.069 496.68 151.798C501.541 146.671 505.311 140.636 508.719 134.465C512.126 128.294 515.215 121.987 518.213 115.635C521.211 109.283 524.073 102.839 526.935 96.4416L544.061 57.9188L578.314 -19.2176Z"
          fill="#919191"
        />
        <path
          d="M590.579 -19.6258L552.102 66.2677L532.886 109.192C529.661 116.361 526.39 123.485 522.983 130.518C521.256 134.057 519.485 137.551 517.622 140.999C515.76 144.448 513.806 147.851 511.671 151.118C509.536 154.385 507.219 157.561 504.539 160.374C503.176 161.781 501.768 163.142 500.223 164.322C498.679 165.501 497.043 166.545 495.317 167.407C493.591 168.269 491.728 168.95 489.866 169.403C488.003 169.857 486.05 170.084 484.097 170.175C480.19 170.311 476.328 169.812 472.512 169.04C468.696 168.269 464.926 167.135 461.201 165.955C457.476 164.73 453.842 163.369 450.162 161.962C442.893 159.103 435.67 155.973 428.538 152.842C414.228 146.535 399.919 140.046 385.609 133.649L342.725 114.41L171.144 37.5458L85.3306 -0.886264C78.153 -4.06246 70.9754 -7.23864 63.7523 -10.2787C56.4839 -13.2734 49.2154 -16.1774 41.6744 -18.4915C37.9039 -19.6258 34.0879 -20.6241 30.1357 -21.2593C26.2289 -21.8946 22.1858 -22.1214 18.1882 -21.5769C14.1905 -21.0324 10.2837 -19.6259 6.87663 -17.4025C3.46953 -15.2246 0.56215 -12.3659 -1.98181 -9.32587L-0.573547 -8.14615C1.87956 -11.0955 4.65066 -13.8179 7.87604 -15.8598C11.056 -17.947 14.6902 -19.2628 18.4607 -19.762C22.2312 -20.3064 26.0926 -20.0796 29.9086 -19.4897C33.7245 -18.8999 37.495 -17.9016 41.2201 -16.8126C48.6703 -14.5439 55.9387 -11.6853 63.1618 -8.69062C70.3848 -5.69592 77.5624 -2.56509 84.74 0.61111L170.644 38.8162L342.316 115.227L385.245 134.329C399.555 140.682 413.865 147.125 428.22 153.386C435.398 156.517 442.621 159.603 449.889 162.461C453.524 163.868 457.203 165.229 460.974 166.454C464.699 167.679 468.469 168.768 472.331 169.54C476.192 170.311 480.099 170.81 484.051 170.674C486.004 170.583 488.003 170.356 489.911 169.903C491.819 169.449 493.682 168.768 495.453 167.861C497.225 166.999 498.906 165.91 500.451 164.685C501.995 163.459 503.449 162.098 504.812 160.692C507.492 157.833 509.854 154.611 511.989 151.344C514.124 148.078 516.078 144.629 517.94 141.181C519.803 137.732 521.575 134.238 523.255 130.699C526.662 123.621 529.933 116.497 533.113 109.328L552.238 66.3584L590.579 -19.6258Z"
          fill="#919191"
        />
        <path
          d="M602.98 -20.1704L563.186 68.6271L543.288 113.049C539.972 120.445 536.656 127.841 533.158 135.191C529.66 142.497 526.071 149.802 521.937 156.744C519.847 160.193 517.622 163.596 515.078 166.726C512.534 169.857 509.672 172.761 506.31 174.985C504.629 176.119 502.857 177.026 500.995 177.752C499.132 178.478 497.179 178.932 495.18 179.204C491.182 179.749 487.139 179.522 483.187 178.841C479.189 178.206 475.283 177.163 471.421 175.937C467.56 174.758 463.744 173.351 459.974 171.899C452.432 168.995 444.982 165.774 437.578 162.552C422.768 156.018 408.004 149.348 393.195 142.723L348.812 122.849L171.37 43.3536L126.987 23.4797C112.178 16.8551 97.4137 10.185 82.6042 3.69647C75.154 0.474889 67.7038 -2.74669 60.1174 -5.60527C56.3014 -7.05725 52.4855 -8.37308 48.5787 -9.55281C44.6719 -10.6872 40.6742 -11.6854 36.5857 -12.2299C32.4972 -12.7744 28.3179 -12.8198 24.2294 -11.9577C23.7296 -11.8216 23.1845 -11.7761 22.6848 -11.64L21.1857 -11.1863C20.9585 -11.0955 20.686 -11.0502 20.4588 -10.9594L19.732 -10.6418L18.2783 -10.0519C17.824 -9.82505 17.3697 -9.55281 16.87 -9.32594C16.4158 -9.0537 15.916 -8.87222 15.5072 -8.5546C14.6441 -7.96473 13.7355 -7.46561 12.9178 -6.78499C9.60158 -4.2894 6.78505 -1.20395 4.28651 2.063C1.78798 5.32995 -0.392557 8.77839 -2.48224 12.3176L-0.937691 13.2251C1.10656 9.73125 3.24167 6.3282 5.64935 3.152C8.05703 -0.024206 10.7827 -2.97356 13.9172 -5.3784C14.6895 -6.01364 15.5526 -6.51273 16.3703 -7.05723C16.7792 -7.32947 17.2335 -7.55633 17.6423 -7.7832C18.0966 -8.01008 18.5054 -8.23695 18.9597 -8.46382L20.3226 -9.00834L21.004 -9.28058C21.2311 -9.37133 21.4583 -9.4167 21.6854 -9.50745L23.0937 -9.96119C23.5479 -10.0973 24.0476 -10.188 24.5473 -10.2788C28.4087 -11.0955 32.4064 -11.0501 36.3586 -10.551C40.3108 -10.0519 44.2176 -9.09907 48.079 -7.96471C51.9404 -6.83035 55.7563 -5.5145 59.5268 -4.10789C67.1133 -1.29469 74.5634 1.88154 81.9682 5.10311C96.8231 11.5916 111.587 18.2162 126.397 24.7955L170.825 44.5788L348.448 123.666L392.877 143.449C407.686 150.029 422.45 156.653 437.305 163.187C444.755 166.409 452.205 169.63 459.746 172.489C463.517 173.941 467.378 175.302 471.24 176.482C475.101 177.662 479.053 178.705 483.096 179.34C487.094 179.976 491.228 180.248 495.271 179.658C497.315 179.386 499.269 178.887 501.222 178.161C503.13 177.435 504.947 176.482 506.628 175.302C510.035 173.033 512.942 170.084 515.486 166.908C518.03 163.732 520.302 160.329 522.346 156.835C526.48 149.847 530.069 142.542 533.567 135.237C537.019 127.886 540.335 120.49 543.652 113.094L563.413 68.6271L602.98 -20.1704Z"
          fill="#919191"
        />
        <path
          d="M614.702 -19.3082L573.59 72.484L553.056 118.403C549.649 126.071 546.197 133.694 542.653 141.317C539.11 148.894 535.43 156.472 531.296 163.732C529.207 167.362 526.981 170.901 524.482 174.259C521.984 177.616 519.167 180.702 515.851 183.243C514.216 184.513 512.444 185.602 510.536 186.464C508.628 187.326 506.675 187.962 504.63 188.325C500.542 189.096 496.317 189.005 492.228 188.37C490.184 188.052 488.14 187.689 486.096 187.19C485.096 186.963 484.097 186.691 483.052 186.419C482.053 186.147 481.053 185.874 480.054 185.557C476.056 184.332 472.104 182.925 468.197 181.428C460.384 178.433 452.706 175.121 445.029 171.763C437.352 168.405 429.72 164.957 422.088 161.554L399.147 151.299L353.31 130.654L169.918 48.5264L124.036 27.9718L101.094 17.7172C93.4626 14.3141 85.7853 10.9111 78.0171 7.73486C70.2489 4.55866 62.4353 1.47323 54.3037 -0.750117C50.2152 -1.88447 46.0813 -2.74658 41.8111 -3.0642C37.5863 -3.38182 33.1798 -3.10961 29.0913 -1.74839C24.9573 -0.387155 21.2322 1.97234 18.1431 4.92167C15.0086 7.82563 12.3738 11.1833 9.96612 14.6772C5.1962 21.6648 1.33483 29.1969 -2.39026 36.7291L-0.754855 37.5458C2.9248 30.0591 6.74074 22.5723 11.4198 15.7207C13.7821 12.3177 16.326 9.05075 19.3243 6.23754C22.3225 3.46971 25.8205 1.20098 29.6364 -0.069502C33.4978 -1.33998 37.6317 -1.65763 41.7202 -1.34001C45.8087 -1.02238 49.8972 -0.205636 53.8949 0.883348C61.8902 3.06132 69.7038 6.10139 77.4265 9.2776C85.1493 12.4538 92.8266 15.8115 100.458 19.2146L123.4 29.4238L169.282 49.8423L352.856 131.561L398.738 151.98L421.679 162.189C429.311 165.592 436.988 168.995 444.665 172.353C452.343 175.711 460.066 179.023 467.879 181.972C471.786 183.47 475.738 184.876 479.781 186.101C480.781 186.419 481.78 186.691 482.825 186.963C483.824 187.236 484.869 187.508 485.869 187.735C487.913 188.234 489.957 188.597 492.047 188.915C496.181 189.504 500.496 189.641 504.63 188.824C506.72 188.415 508.719 187.78 510.672 186.873C512.58 186.011 514.397 184.876 516.078 183.606C519.44 181.019 522.256 177.889 524.8 174.485C527.344 171.128 529.525 167.543 531.614 163.913C535.794 156.608 539.383 149.031 542.926 141.453C546.469 133.83 549.876 126.207 553.284 118.539L573.726 72.5748L614.702 -19.3082Z"
          fill="#919191"
        />
        <path
          d="M626.694 -19.036L584.083 76.0232L562.777 123.576C559.234 131.516 555.69 139.457 552.056 147.306C548.422 155.201 544.697 163.051 540.517 170.629C538.428 174.44 536.202 178.161 533.703 181.7C531.205 185.239 528.433 188.597 525.163 191.365C523.527 192.771 521.756 193.996 519.848 194.995C517.94 195.993 515.941 196.764 513.851 197.263C509.672 198.307 505.311 198.262 501.04 197.717C496.77 197.173 492.545 196.129 488.411 194.859C484.277 193.588 480.189 192.136 476.146 190.593C468.06 187.508 460.11 184.059 452.16 180.566C444.21 177.072 436.306 173.533 428.401 169.993L404.642 159.376L357.125 138.095L167.191 53.0184L119.673 31.7379C111.769 28.1987 103.819 24.6595 95.8691 21.211C87.9192 17.7626 79.8785 14.4049 71.7015 11.5009C67.613 10.049 63.4336 8.73308 59.1634 7.73484C54.8932 6.73661 50.5321 6.01063 46.0802 6.10138C43.8542 6.14675 41.6282 6.3736 39.4477 6.87272C37.2672 7.37184 35.132 8.14324 33.1786 9.18685C29.181 11.2287 25.7739 14.2234 22.8665 17.5357C19.9591 20.848 17.4606 24.478 15.1438 28.1986C12.827 31.9193 10.7827 35.7308 8.73845 39.633C4.74079 47.392 1.10656 55.2871 -2.48224 63.1823L-0.846835 63.9536C2.74197 56.0585 6.33077 48.1633 10.283 40.4497C12.2818 36.5929 14.3261 32.7815 16.5975 29.1516C18.8689 25.4762 21.2765 21.937 24.0931 18.7155C26.9096 15.4939 30.135 12.6806 33.8601 10.7295C37.5852 8.77844 41.8099 7.871 46.0347 7.82562C50.2595 7.78025 54.5297 8.46086 58.7091 9.41373C62.8885 10.412 67.0224 11.6824 71.0655 13.089C79.1971 15.9476 87.1924 19.3053 95.1877 22.7084C103.138 26.1568 111.087 29.6506 118.992 33.1898L166.555 54.3797L356.716 139.048L404.324 160.102L428.083 170.674C435.988 174.213 443.938 177.752 451.887 181.201C459.837 184.649 467.833 188.098 475.919 191.183C479.962 192.726 484.096 194.178 488.23 195.448C492.409 196.674 496.634 197.717 500.95 198.262C505.265 198.806 509.717 198.806 513.987 197.763C516.122 197.218 518.167 196.447 520.12 195.403C522.073 194.359 523.845 193.089 525.526 191.682C528.842 188.824 531.659 185.466 534.157 181.881C536.656 178.342 538.882 174.576 540.972 170.765C545.151 163.142 548.876 155.292 552.51 147.397C556.144 139.502 559.642 131.561 563.186 123.621L584.401 76.0232L626.694 -19.036Z"
          fill="#919191"
        />
        <path
          d="M639.096 -19.6713L594.94 78.9272L572.862 128.249C569.183 136.462 565.548 144.72 561.778 152.887C558.053 161.055 554.237 169.222 550.012 177.163C547.877 181.11 545.651 185.058 543.198 188.778C541.971 190.639 540.654 192.499 539.246 194.223C537.837 195.993 536.338 197.672 534.748 199.214C533.113 200.757 531.387 202.164 529.479 203.344C527.571 204.523 525.572 205.476 523.437 206.111C519.166 207.427 514.624 207.609 510.172 207.155C507.946 206.928 505.72 206.52 503.539 206.066C501.359 205.567 499.178 205.022 497.043 204.387C492.727 203.117 488.503 201.619 484.323 200.031C475.919 196.81 467.697 193.225 459.429 189.595C451.206 185.965 442.984 182.29 434.761 178.615L410.14 167.589L360.896 145.537L163.83 57.2836L114.54 35.2317C106.318 31.6017 98.05 27.9718 89.6913 24.6141C85.512 22.9353 81.2872 21.3472 77.0169 19.8952C74.8818 19.1692 72.7013 18.5339 70.5208 17.8987C68.3402 17.3088 66.1143 16.7643 63.8883 16.356C59.4364 15.5392 54.8027 15.0855 50.2145 15.6753C47.9431 15.9476 45.6717 16.5375 43.4912 17.3996C41.3561 18.2617 39.3118 19.3961 37.4038 20.7573C35.5413 22.1185 33.815 23.6613 32.2251 25.2947C30.6351 26.9282 29.1814 28.6978 27.8185 30.5128C25.0929 34.1427 22.7306 38.0449 20.4592 41.9471C16.0073 49.8422 12.1459 58.0096 8.32999 66.177C4.6049 74.3444 0.970674 82.5571 -2.70898 90.8152L-1.07358 91.5412C2.56065 83.3285 6.19488 75.0703 9.96539 66.903C13.7359 58.7356 17.5973 50.6136 21.9584 42.7638C24.1843 38.8617 26.5011 35.0502 29.1814 31.4656C30.4988 29.696 31.9071 27.9718 33.4516 26.3837C34.9962 24.7956 36.6316 23.2982 38.4032 22.0277C40.1749 20.7573 42.0829 19.6683 44.1272 18.8515C46.1714 18.0348 48.2611 17.4903 50.4416 17.2181C54.8027 16.6282 59.2546 17.082 63.6157 17.8533C65.7963 18.2617 67.9768 18.8062 70.1119 19.3961C72.247 19.9859 74.3821 20.6211 76.5172 21.3471C80.7875 22.7537 84.9668 24.3419 89.1462 25.9753C97.5049 29.2877 105.727 32.9176 113.95 36.5022L163.284 58.418L360.532 146.263L409.822 168.315L434.489 179.295C442.711 182.97 450.934 186.6 459.156 190.23C467.379 193.815 475.647 197.4 484.096 200.621C488.321 202.209 492.546 203.707 496.861 204.977C499.042 205.612 501.222 206.157 503.403 206.656C505.629 207.11 507.855 207.518 510.081 207.745C514.578 208.199 519.212 208.062 523.528 206.656C525.708 205.975 527.752 205.022 529.706 203.797C531.614 202.618 533.431 201.166 535.066 199.623C536.702 198.035 538.201 196.356 539.609 194.586C541.017 192.817 542.335 191.002 543.561 189.096C546.06 185.33 548.286 181.382 550.375 177.435C554.6 169.449 558.371 161.282 562.096 153.069C565.821 144.856 569.455 136.643 573.089 128.385L595.076 79.0179L639.096 -19.6713Z"
          fill="#919191"
        />
        <path
          d="M651.134 -19.3989L605.524 82.421L582.719 133.331L571.317 158.786C567.456 167.271 563.594 175.711 559.324 183.969C557.189 188.098 554.963 192.181 552.465 196.084C551.238 198.035 549.921 199.986 548.558 201.846C547.195 203.707 545.696 205.521 544.106 207.155C540.926 210.467 537.155 213.326 532.84 214.959C528.524 216.593 523.845 216.956 519.257 216.593C516.94 216.411 514.669 216.048 512.397 215.595C510.126 215.141 507.9 214.551 505.674 213.916C501.222 212.645 496.861 211.057 492.5 209.424C483.823 206.111 475.328 202.391 466.833 198.67L365.075 153.16L161.648 62.0479L136.209 50.659C127.714 46.8929 119.264 43.0815 110.724 39.3608C106.454 37.5005 102.183 35.7308 97.8677 33.9612C93.5521 32.237 89.191 30.5581 84.7845 29.1062C80.378 27.6542 75.8352 26.3384 71.247 25.5216C66.6134 24.7049 61.8434 24.3419 57.1189 25.1133C54.7567 25.5216 52.4398 26.2022 50.2593 27.2005C48.0788 28.1987 46.0345 29.4692 44.172 30.9666C40.4469 33.9159 37.3578 37.5912 34.6775 41.4026C31.9519 45.2141 29.5896 49.2524 27.3182 53.3361C25.0923 57.4197 23.0026 61.5942 20.9583 65.7686C16.9152 74.1629 13.0993 82.6479 9.28336 91.1329L-2.07361 116.588L-0.438205 117.314L10.8733 91.8135C14.6439 83.3285 18.4598 74.8435 22.4574 66.4946C24.4563 62.3202 26.546 58.1458 28.7719 54.1075C30.9979 50.0691 33.3601 46.0762 35.995 42.3101C38.6298 38.5441 41.628 35.0048 45.1714 32.1916C46.9431 30.785 48.851 29.5599 50.8953 28.6071C52.9396 27.6542 55.1201 27.019 57.3461 26.656C61.798 25.8846 66.4316 26.2022 70.929 27.019C75.4264 27.8357 79.8783 29.1062 84.2848 30.5582C88.6913 32.0102 93.007 33.6436 97.3226 35.3678C101.638 37.0921 105.908 38.8617 110.179 40.722C118.719 44.3974 127.169 48.1634 135.664 51.9295L161.103 63.273L364.711 153.931L466.56 199.214C475.055 202.935 483.596 206.61 492.273 209.923C496.634 211.556 500.995 213.099 505.492 214.369C507.718 215.005 509.989 215.595 512.261 216.048C514.532 216.502 516.849 216.865 519.166 217.047C523.8 217.41 528.615 217.047 532.976 215.322C537.382 213.643 541.198 210.74 544.424 207.382C546.059 205.703 547.513 203.888 548.921 202.028C550.329 200.167 551.601 198.216 552.828 196.265C555.327 192.318 557.507 188.234 559.688 184.105C563.958 175.847 567.819 167.362 571.635 158.877L582.992 133.422L605.706 82.4664L651.134 -19.3989Z"
          fill="#919191"
        />
        <path
          d="M663.173 -19.2629L616.019 85.9602L592.442 138.594L580.676 164.911C576.724 173.669 572.726 182.426 568.41 191.002C566.23 195.267 564.004 199.532 561.505 203.616C559.052 207.699 556.326 211.692 553.146 215.277C549.967 218.816 546.241 221.947 541.835 223.853C539.654 224.806 537.338 225.441 534.975 225.758C532.613 226.076 530.251 226.121 527.843 225.985C523.073 225.668 518.394 224.624 513.806 223.308C509.218 221.992 504.675 220.404 500.223 218.68C491.274 215.232 482.461 211.42 473.693 207.518L368.573 160.465L158.287 66.3131L131.985 54.5612C123.217 50.659 114.404 46.8022 105.5 43.2176C101.048 41.448 96.5054 39.7238 91.9627 38.2264C89.6913 37.5004 87.3744 36.7744 85.0122 36.1846C82.6499 35.5947 80.2877 35.0502 77.9254 34.6872C73.1555 33.9158 68.1585 33.7343 63.3431 34.8687C60.9354 35.4132 58.6186 36.3206 56.4381 37.5004C54.2575 38.6801 52.2587 40.1775 50.4416 41.8109C46.8073 45.0779 43.8091 48.9801 41.1289 53.0184C38.4486 57.0567 36.0864 61.2765 33.815 65.5417C29.3176 74.0721 25.32 82.8293 21.3223 91.5866C17.3701 100.344 13.4633 109.146 9.55649 117.904L-2.25476 144.13L-0.619357 144.856L11.101 118.494C15.0078 109.736 18.8692 100.934 22.8214 92.1764C26.7737 83.4192 30.7713 74.7073 35.2232 66.2223C37.4492 62.0025 39.8115 57.8281 42.4463 53.8351C45.0811 49.8876 47.9885 46.0761 51.4864 42.8999C54.9389 39.7691 59.1183 37.3189 63.6611 36.3207C68.2039 35.2317 73.0192 35.4132 77.6529 36.1391C80.0151 36.5021 82.3319 37.0013 84.6033 37.5912C86.9202 38.181 89.1916 38.8616 91.463 39.5876C96.0057 41.0396 100.503 42.7184 104.955 44.488C113.859 48.0272 122.626 51.8841 131.439 55.7409L157.742 67.4474L368.21 161.191L473.466 208.017C482.279 211.874 491.047 215.685 500.041 219.134C504.539 220.813 509.081 222.446 513.715 223.762C518.349 225.078 523.073 226.121 527.889 226.439C530.296 226.575 532.749 226.53 535.112 226.212C537.519 225.849 539.882 225.214 542.108 224.261C544.334 223.308 546.423 222.038 548.331 220.54C550.239 219.043 551.965 217.364 553.601 215.549C556.781 211.919 559.506 207.926 562.005 203.797C564.503 199.668 566.729 195.403 568.91 191.138C573.226 182.562 577.178 173.805 581.13 165.002L592.85 138.685L616.337 86.0055L663.173 -19.2629Z"
          fill="#919191"
        />
        <path
          d="M675.347 -19.3535L626.694 89.2272L602.39 143.54L590.261 170.674C586.218 179.704 582.129 188.778 577.723 197.626C575.542 202.073 573.225 206.474 570.772 210.74C568.274 215.005 565.593 219.179 562.459 222.991C559.324 226.802 555.645 230.205 551.238 232.428C549.058 233.517 546.695 234.334 544.288 234.788C541.88 235.242 539.427 235.378 536.974 235.287C532.068 235.106 527.207 234.062 522.437 232.746C517.667 231.43 513.033 229.751 508.4 228.027C499.178 224.488 490.092 220.495 481.007 216.502L372.479 167.952L155.47 70.8052C146.43 66.7669 137.39 62.6832 128.305 58.7356C123.762 56.7845 119.174 54.8335 114.585 52.9731C109.997 51.1128 105.363 49.3432 100.639 47.8004C98.2767 47.0291 95.9145 46.3031 93.4614 45.6678C91.0537 45.0326 88.6006 44.4881 86.1475 44.0797C81.1959 43.263 76.0625 43.0815 71.1109 44.2612C68.6123 44.8511 66.2501 45.804 64.0241 47.0745C61.7981 48.345 59.7993 49.8877 57.9368 51.6119C54.2571 55.0603 51.2134 59.144 48.4878 63.3184C45.7621 67.5382 43.3544 71.8488 41.0376 76.2955C38.7208 80.6968 36.5857 85.1889 34.4506 89.6809C30.2258 98.665 26.1827 107.74 22.1396 116.769L-2.1189 170.992L-0.483492 171.718L23.6841 117.359C27.7272 108.284 31.7249 99.2095 35.9042 90.2708C37.9939 85.7787 40.1745 81.332 42.4459 76.9307C44.7173 72.5294 47.1249 68.2189 49.7598 64.0898C52.44 59.9607 55.3928 56.0132 58.9362 52.7008C60.7079 51.0674 62.6613 49.57 64.751 48.3903C66.8406 47.2105 69.0666 46.3031 71.4289 45.7132C76.1079 44.5789 81.0596 44.7604 85.8749 45.5317C88.2826 45.8947 90.6903 46.4392 93.0525 47.0745C95.4148 47.7097 97.777 48.3903 100.139 49.207C104.818 50.7498 109.452 52.5194 114.04 54.3344C118.628 56.1947 123.171 58.1004 127.714 60.0515C136.8 63.9991 145.84 68.0374 154.88 72.0303L372.116 168.768L480.734 217.092C489.82 221.085 498.905 225.032 508.173 228.572C512.806 230.341 517.485 231.975 522.301 233.291C527.071 234.606 531.977 235.65 536.974 235.832C539.472 235.922 541.971 235.786 544.424 235.332C546.877 234.879 549.285 234.062 551.511 232.928C556.008 230.659 559.733 227.165 562.868 223.354C566.002 219.497 568.728 215.322 571.226 211.012C573.725 206.701 575.996 202.3 578.177 197.853C582.538 188.96 586.626 179.885 590.67 170.856L602.753 143.676L626.966 89.3179L675.347 -19.3535Z"
          fill="#C6C6C6"
        />
        <path
          d="M687.749 -19.9435L637.506 92.2218L612.384 148.305L599.846 176.346C595.667 185.693 591.487 195.04 587.035 204.251C584.809 208.834 582.493 213.417 579.994 217.863C577.496 222.31 574.815 226.666 571.681 230.75C568.592 234.788 564.957 238.509 560.551 241.004C558.37 242.275 556.008 243.228 553.51 243.817C551.057 244.407 548.513 244.634 545.969 244.589C540.881 244.543 535.838 243.5 530.932 242.184C528.479 241.503 526.026 240.732 523.618 239.915C521.21 239.098 518.803 238.236 516.395 237.329C506.855 233.699 497.497 229.57 488.139 225.441L376.068 175.302L151.927 74.9796C142.569 70.8052 133.211 66.6761 123.716 62.7739C118.992 60.8228 114.177 59.0079 109.316 57.329C104.455 55.6955 99.5034 54.2435 94.37 53.3814C91.826 52.973 89.2367 52.6554 86.6018 52.6554C84.0125 52.6554 81.3776 52.8823 78.8337 53.5176C76.2897 54.1528 73.8366 55.151 71.5652 56.5123C69.2938 57.8281 67.2041 59.4616 65.3416 61.2766C61.5711 64.9065 58.5274 69.1263 55.7563 73.4823C52.9852 77.8382 50.5321 82.3756 48.1699 86.913C43.4908 96.0787 39.266 105.38 35.0412 114.728L22.5031 142.769L-2.48224 198.942L-0.846835 199.668L24.1385 143.54L36.6312 115.454C40.8105 106.106 45.0353 96.8047 49.669 87.6844C51.9858 83.147 54.4389 78.6549 57.1191 74.3444C59.8448 70.0338 62.7976 65.9047 66.4319 62.4109C68.249 60.6867 70.2024 59.0986 72.3375 57.8281C74.4726 56.5576 76.7894 55.6048 79.1971 55.0149C84.0579 53.8352 89.1458 54.0167 94.1429 54.8788C99.1399 55.6955 104.046 57.1475 108.862 58.7356C113.677 60.3691 118.447 62.1841 123.171 64.0898C132.62 67.9466 141.978 72.0757 151.337 76.2047L375.705 176.119L487.866 226.076C497.224 230.205 506.628 234.289 516.213 237.919C518.621 238.826 521.029 239.688 523.436 240.505C525.889 241.322 528.297 242.093 530.796 242.774C535.747 244.09 540.835 245.133 545.969 245.179C548.558 245.224 551.147 244.952 553.646 244.362C556.144 243.772 558.598 242.774 560.824 241.503C565.321 238.917 568.955 235.151 572.09 231.067C575.224 226.984 577.904 222.582 580.403 218.136C582.901 213.644 585.218 209.061 587.444 204.478C591.896 195.267 596.076 185.874 600.209 176.527L612.702 148.441L637.733 92.3126L687.749 -19.9435Z"
          fill="#C6C6C6"
        />
        <path
          d="M699.516 -19.172L647.819 96.2602L621.97 153.976L609.069 182.834C604.753 192.454 600.483 202.073 595.94 211.602C593.669 216.366 591.307 221.085 588.808 225.668C586.264 230.296 583.584 234.833 580.449 239.008C577.315 243.182 573.681 247.13 569.274 249.898C567.048 251.259 564.641 252.302 562.142 252.983C559.643 253.664 557.009 253.936 554.419 253.936C549.195 253.936 544.016 252.847 538.928 251.486C533.886 250.079 528.889 248.355 523.983 246.449C514.17 242.683 504.539 238.418 494.909 234.153L379.476 182.562L148.794 79.3809C139.163 75.1611 129.441 70.9867 119.493 67.4475C114.496 65.7233 109.453 64.1352 104.229 63.0916C101.64 62.5924 98.9593 62.1841 96.2791 62.0933C93.5988 61.9572 90.9186 62.0933 88.2384 62.5925C85.6035 63.0916 83.0141 63.9991 80.6065 65.2695C78.2442 66.54 76.0183 68.1735 74.0649 69.9885C70.1126 73.6184 66.9327 77.9743 64.0707 82.421C61.2088 86.9131 58.6648 91.5413 56.2571 96.2602C53.8495 100.979 51.5781 105.743 49.3521 110.508C44.9002 120.082 40.6299 129.701 36.3597 139.32L23.4582 168.178L-2.39026 225.895L-0.754855 226.621L24.9573 168.859L37.8134 139.956C42.0836 130.336 46.3539 120.672 50.7604 111.143C52.9863 106.379 55.2577 101.614 57.62 96.9408C60.0276 92.2672 62.5262 87.6391 65.3427 83.2378C68.1592 78.8364 71.2938 74.6166 75.0643 71.0775C76.9722 69.3532 79.0619 67.8105 81.2879 66.5854C83.5593 65.4057 85.967 64.5436 88.5109 64.0444C93.5534 63.0462 98.8231 63.4999 103.911 64.4982C109.044 65.4964 114.041 67.0845 118.993 68.7633C128.896 72.2572 138.572 76.4316 148.203 80.6061L379.068 183.379L494.5 234.788C504.131 239.053 513.807 243.273 523.619 247.039C528.525 248.899 533.522 250.669 538.61 252.075C543.698 253.437 548.922 254.48 554.238 254.526C556.872 254.526 559.553 254.253 562.142 253.573C564.731 252.892 567.184 251.849 569.456 250.442C573.999 247.629 577.633 243.636 580.767 239.416C583.902 235.151 586.628 230.613 589.126 225.985C591.625 221.357 593.987 216.638 596.258 211.874C600.801 202.345 605.071 192.726 609.342 183.061L622.198 154.158L647.955 96.3963L699.516 -19.172Z"
          fill="#C6C6C6"
        />
        <path
          d="M711.418 -18.6729L658.267 99.9809L631.692 159.285L618.427 188.96C614.02 198.851 609.614 208.743 604.98 218.544C602.663 223.444 600.301 228.299 597.757 233.064C596.485 235.469 595.168 237.828 593.759 240.142C592.397 242.456 590.943 244.725 589.353 246.948C587.808 249.126 586.128 251.259 584.265 253.255C582.402 255.206 580.449 257.021 578.223 258.564C575.997 260.061 573.589 261.286 571 262.058C568.456 262.829 565.776 263.192 563.096 263.283C560.415 263.328 557.735 263.101 555.055 262.693C552.375 262.285 549.785 261.695 547.15 260.969C541.926 259.562 536.838 257.747 531.796 255.842C521.711 251.939 511.808 247.583 501.904 243.182L383.337 190.14L264.862 137.006L205.578 110.462L175.959 97.213C166.056 92.8117 156.198 88.365 146.249 84.1452C141.252 82.0126 136.255 79.9708 131.167 78.0651C126.079 76.1593 120.946 74.4351 115.631 73.1193C112.996 72.484 110.316 71.9395 107.59 71.6219C104.865 71.3043 102.093 71.2135 99.3224 71.4404C96.5513 71.7127 93.8256 72.3025 91.2362 73.3461C88.6468 74.3898 86.2391 75.7964 84.104 77.5659C79.7884 81.0144 76.3359 85.3703 73.2922 89.9078C71.7476 92.1765 70.3394 94.4906 68.9765 96.85C67.6137 99.2095 66.3417 101.614 65.0697 104.019C62.5712 108.829 60.209 113.729 57.8921 118.63C55.5753 123.53 53.3493 128.476 51.1234 133.422L-1.98181 252.121L-0.346408 252.847L52.5316 134.057C54.7576 129.111 56.9836 124.165 59.255 119.265C61.5264 114.365 63.8886 109.464 66.3871 104.7C67.6137 102.295 68.8857 99.9355 70.2485 97.576C71.5659 95.2165 72.9742 92.9478 74.4733 90.7245C77.4715 86.2778 80.8332 82.0126 84.9671 78.7003C87.0114 77.0215 89.3282 75.7056 91.7359 74.7074C94.189 73.7091 96.7784 73.1193 99.4132 72.8924C104.683 72.3933 110.043 73.2554 115.268 74.4805C120.492 75.751 125.58 77.4752 130.668 79.3356C135.71 81.2413 140.753 83.2377 145.704 85.3703C155.653 89.5901 165.556 93.9915 175.414 98.3928L205.078 111.597L264.407 138.05L383.065 190.911L501.723 243.772C511.626 248.128 521.529 252.484 531.66 256.386C536.702 258.292 541.835 260.107 547.105 261.513C549.74 262.239 552.375 262.829 555.055 263.238C557.735 263.646 560.461 263.918 563.186 263.827C565.912 263.737 568.638 263.374 571.273 262.557C573.907 261.74 576.361 260.515 578.632 258.972C580.903 257.43 582.902 255.569 584.765 253.618C586.627 251.622 588.308 249.489 589.853 247.266C591.443 245.043 592.896 242.774 594.259 240.414C595.622 238.1 596.985 235.695 598.211 233.336C600.755 228.572 603.118 223.671 605.434 218.771C610.068 208.97 614.429 199.033 618.836 189.141L632.055 159.467L658.54 100.117L711.418 -18.6729Z"
          fill="#C6C6C6"
        />
        <path
          d="M723.774 -19.1268L669.079 102.975L641.731 164.049L628.057 194.586C623.514 204.75 619.017 214.959 614.293 225.078C611.93 230.114 609.523 235.151 606.933 240.097C605.661 242.592 604.344 244.997 602.936 247.447C601.573 249.852 600.119 252.257 598.575 254.526C597.03 256.84 595.349 259.063 593.577 261.15C591.76 263.238 589.807 265.234 587.581 266.868C585.4 268.546 582.993 269.953 580.358 270.861C577.769 271.813 575.043 272.358 572.272 272.494C566.73 272.812 561.233 271.813 555.872 270.407C550.512 269 545.242 267.14 540.063 265.189C529.66 261.196 519.485 256.704 509.309 252.166L387.289 197.536L265.27 142.95L204.261 115.635L173.733 101.977C163.557 97.4852 153.381 92.9478 142.978 88.8641C140.389 87.8658 137.754 86.8676 135.119 85.9601C132.485 85.0526 129.804 84.1905 127.124 83.4192C121.764 81.8764 116.176 80.6967 110.497 80.6513C107.681 80.6513 104.819 80.9235 102.048 81.6949C100.64 82.0579 99.3222 82.557 98.0048 83.1469C96.7328 83.7821 95.4608 84.4174 94.2797 85.2341C91.872 86.7769 89.7369 88.6826 87.7835 90.7244C85.8301 92.7663 84.1038 94.9896 82.4684 97.3037C79.1976 101.886 76.4265 106.787 73.7917 111.687C71.1569 116.633 68.7492 121.67 66.3415 126.706C61.6171 136.825 57.0743 147.034 52.5315 157.198L-2.0274 279.3L-0.392001 280.026L54.076 157.833C58.6188 147.624 63.1162 137.46 67.7952 127.341C70.1575 122.305 72.6106 117.314 75.2 112.368C77.7894 107.468 80.5605 102.612 83.7404 98.1204C85.3304 95.8517 87.0567 93.7191 88.9192 91.7226C90.7817 89.7262 92.8714 87.9112 95.1428 86.4138C99.6402 83.3738 105.137 81.9672 110.588 82.0579C116.085 82.1033 121.491 83.2376 126.806 84.735C129.486 85.5064 132.121 86.3231 134.711 87.276C137.345 88.1835 139.935 89.1363 142.524 90.1799C152.882 94.2182 163.057 98.7103 173.233 103.248L203.761 116.815L264.816 143.994L386.926 198.398L509.036 252.802C519.212 257.294 529.433 261.786 539.836 265.779C545.061 267.73 550.33 269.59 555.736 270.997C561.142 272.403 566.73 273.401 572.317 273.084C575.134 272.948 577.905 272.358 580.54 271.405C583.175 270.452 585.628 269 587.899 267.321C590.125 265.642 592.124 263.601 593.941 261.513C595.758 259.381 597.439 257.112 598.983 254.798C600.528 252.484 601.982 250.079 603.39 247.674C604.753 245.269 606.116 242.774 607.388 240.324C609.977 235.378 612.339 230.341 614.701 225.259C619.381 215.141 623.878 204.932 628.421 194.768L642.049 164.231L669.306 103.112L723.774 -19.1268Z"
          fill="#C6C6C6"
        />
        <path
          d="M736.266 -19.989L623.65 231.249C621.242 236.467 618.789 241.639 616.2 246.767C614.928 249.308 613.565 251.849 612.202 254.39C610.839 256.885 609.386 259.381 607.841 261.786C604.752 266.595 601.345 271.223 597.029 274.99C594.849 276.85 592.487 278.438 589.897 279.572C587.308 280.707 584.537 281.433 581.72 281.705C576.042 282.295 570.318 281.342 564.821 279.981C562.05 279.3 559.324 278.438 556.599 277.576C553.873 276.668 551.193 275.716 548.512 274.672C537.837 270.588 527.343 265.915 516.849 261.286L391.332 205.113L265.815 148.94L203.033 120.853C192.585 116.179 182.137 111.46 171.643 106.878C166.373 104.564 161.103 102.295 155.788 100.162C150.473 97.9843 145.113 95.9424 139.662 94.1275C134.21 92.3579 128.577 90.8151 122.808 90.2253C119.9 89.9077 116.993 89.8623 114.086 90.2253C111.178 90.6336 108.316 91.405 105.636 92.6755C103.001 93.9459 100.548 95.6248 98.3676 97.5759C96.187 99.527 94.2336 101.705 92.4619 103.974C88.9186 108.556 85.9203 113.502 83.1492 118.539C80.3781 123.575 77.8342 128.748 75.3811 133.921C72.928 139.093 70.5203 144.311 68.158 149.575L54.1208 180.974L-2.1189 306.615L-0.483493 307.341L55.5291 181.609L69.5209 150.165C71.8831 144.947 74.2454 139.729 76.6985 134.556C79.1516 129.383 81.6955 124.256 84.4212 119.219C87.1469 114.228 90.0997 109.282 93.5976 104.836C95.3239 102.612 97.2319 100.48 99.3216 98.6195C101.411 96.7138 103.728 95.1257 106.227 93.9459C108.725 92.7208 111.451 91.9949 114.222 91.6319C116.993 91.2689 119.81 91.3142 122.626 91.6319C128.259 92.2217 133.756 93.7191 139.207 95.4433C144.613 97.2129 149.974 99.2548 155.289 101.387C160.604 103.52 165.873 105.789 171.098 108.103C181.591 112.686 192.04 117.359 202.534 122.033L265.36 150.029L390.969 205.975L516.577 261.922C527.07 266.55 537.564 271.178 548.285 275.262C550.965 276.26 553.691 277.258 556.417 278.12C559.143 279.028 561.914 279.845 564.685 280.525C570.227 281.886 576.042 282.839 581.811 282.249C584.673 281.977 587.535 281.206 590.17 280.026C592.805 278.846 595.258 277.213 597.438 275.353C601.799 271.541 605.252 266.868 608.341 262.012C609.885 259.608 611.339 257.112 612.702 254.571C614.11 252.075 615.428 249.535 616.7 246.948C619.289 241.821 621.742 236.648 624.104 231.43L736.266 -19.989Z"
          fill="#C6C6C6"
        />
        <path
          d="M748.214 -19.5804L632.691 238.282C630.238 243.636 627.739 248.945 625.105 254.208C622.47 259.472 619.744 264.69 616.655 269.681C615.11 272.176 613.475 274.627 611.703 276.941C609.932 279.255 607.978 281.478 605.843 283.475L605.025 284.201L604.162 284.881C603.617 285.38 602.981 285.743 602.436 286.197C601.209 287.014 599.983 287.785 598.666 288.42C596.076 289.736 593.214 290.508 590.352 290.871C587.445 291.234 584.537 291.188 581.63 290.871C578.723 290.553 575.861 290.008 572.999 289.283C567.32 287.876 561.778 285.925 556.281 283.838C545.288 279.618 534.567 274.853 523.8 270.089L394.967 212.464L266.179 154.838L201.762 126.026C191.041 121.216 180.32 116.406 169.463 111.824C164.057 109.555 158.606 107.331 153.018 105.29C147.476 103.293 141.843 101.478 136.028 100.298C133.121 99.754 130.168 99.3002 127.17 99.2548C126.443 99.2548 125.671 99.2095 124.944 99.2548L123.808 99.3003L122.672 99.391L122.127 99.4364L121.582 99.5271L120.446 99.7086L119.356 99.9355L118.811 100.072L118.266 100.208L117.175 100.525L116.085 100.888L115.54 101.07L115.04 101.297L113.996 101.75C113.314 102.113 112.633 102.386 111.997 102.794C111.679 102.976 111.361 103.157 110.997 103.339L110.043 103.974C107.545 105.607 105.319 107.694 103.275 109.872C99.2315 114.274 96.0061 119.31 93.0533 124.392C91.5542 126.933 90.1459 129.565 88.8285 132.151C87.4657 134.783 86.1483 137.415 84.8763 140.046C79.7429 150.664 74.973 161.418 70.1576 172.171L55.757 204.433L-1.98181 333.477L-0.346408 334.203L57.1198 205.159L71.4751 172.897C76.245 162.144 81.0149 151.39 86.1028 140.772C87.3748 138.141 88.6922 135.509 90.0551 132.877C91.4179 130.291 92.7807 127.705 94.2344 125.164C97.1872 120.082 100.367 115.136 104.274 110.871C106.227 108.738 108.362 106.742 110.77 105.154L111.679 104.564C111.997 104.382 112.315 104.201 112.587 104.019C113.178 103.656 113.859 103.339 114.495 103.021L115.495 102.613L115.994 102.386L116.494 102.204L117.493 101.841L118.538 101.569L119.038 101.433L119.583 101.342L120.628 101.115L121.673 100.934L122.218 100.843L122.763 100.798L123.853 100.707L124.944 100.661C125.671 100.616 126.397 100.661 127.124 100.616C130.032 100.661 132.894 101.07 135.755 101.614C141.479 102.749 147.067 104.518 152.564 106.515C158.061 108.511 163.512 110.689 168.918 112.958C179.73 117.541 190.451 122.35 201.217 127.115L265.679 155.837L394.604 213.281L523.528 270.724C534.294 275.489 545.061 280.253 556.054 284.427C561.551 286.515 567.139 288.42 572.863 289.872C575.724 290.598 578.632 291.143 581.585 291.46C584.537 291.778 587.49 291.823 590.443 291.46C593.396 291.052 596.303 290.281 598.938 288.92C600.301 288.284 601.528 287.468 602.754 286.651C603.345 286.197 603.981 285.789 604.526 285.29L605.389 284.564L606.207 283.838C608.387 281.841 610.341 279.618 612.112 277.258C613.884 274.899 615.519 272.449 617.064 269.953C620.153 264.916 622.879 259.698 625.513 254.435C628.103 249.172 630.601 243.817 633.054 238.463L748.214 -19.5804Z"
          fill="#C6C6C6"
        />
        <path
          d="M760.071 -18.9452L641.595 245.542C639.096 251.032 636.552 256.522 633.872 261.922C631.192 267.321 628.421 272.721 625.332 277.848C622.197 282.975 618.79 288.012 614.474 292.186C612.294 294.228 609.886 296.089 607.251 297.45C605.934 298.13 604.526 298.675 603.117 299.174L602.027 299.492L601.482 299.628L600.937 299.764L599.847 299.991L598.756 300.172C598.393 300.218 598.029 300.263 597.666 300.308L596.53 300.399C595.804 300.399 595.031 300.49 594.304 300.49H593.169C592.805 300.49 592.442 300.445 592.033 300.445C591.306 300.399 590.534 300.354 589.807 300.263C586.809 299.945 583.856 299.356 580.949 298.675C575.134 297.223 569.41 295.227 563.777 293.094C552.511 288.783 541.517 283.838 530.478 278.937L398.329 219.724L266.179 160.601L200.127 131.062C189.088 126.162 178.094 121.216 166.828 116.815C161.195 114.637 155.471 112.595 149.656 110.961C146.749 110.19 143.751 109.509 140.752 109.056C137.754 108.647 134.665 108.42 131.576 108.693C130.804 108.783 130.031 108.829 129.259 108.965C128.487 109.056 127.76 109.237 126.988 109.419C125.489 109.782 123.99 110.235 122.581 110.871L122.036 111.098L121.536 111.37L120.492 111.869C119.81 112.277 119.129 112.595 118.493 113.049C117.175 113.865 115.994 114.818 114.768 115.816C110.134 119.9 106.5 124.891 103.274 130.019C100.049 135.191 97.2325 140.545 94.5523 145.945C91.872 151.345 89.2826 156.835 86.7841 162.325C81.787 173.306 76.9263 184.377 71.9746 195.403L57.1651 228.481L-2.0274 360.702L-0.392001 361.428L58.6188 229.071L73.3829 195.993C78.3345 184.967 83.1499 173.896 88.1469 162.915C90.6455 157.425 93.1894 151.98 95.8697 146.535C98.5499 141.135 101.366 135.827 104.501 130.699C107.681 125.617 111.224 120.717 115.676 116.815C116.812 115.862 117.948 114.954 119.22 114.183C119.81 113.775 120.492 113.412 121.128 113.049L122.127 112.55L122.627 112.323L123.126 112.096C124.489 111.506 125.898 111.052 127.306 110.735C128.033 110.598 128.759 110.417 129.486 110.326C130.213 110.19 130.94 110.145 131.667 110.054C134.62 109.827 137.572 110.009 140.525 110.417C143.478 110.825 146.385 111.461 149.293 112.277C155.062 113.865 160.741 115.862 166.374 118.04C177.594 122.396 188.588 127.342 199.627 132.197L265.725 161.645L397.965 220.54L530.206 279.482C541.245 284.337 552.284 289.282 563.55 293.593C569.183 295.726 574.907 297.722 580.767 299.174C583.72 299.9 586.673 300.49 589.716 300.762C590.488 300.853 591.215 300.898 591.988 300.944C592.351 300.944 592.76 300.989 593.123 300.989H594.259C595.031 300.989 595.758 300.944 596.53 300.898L597.666 300.808C598.029 300.762 598.438 300.717 598.802 300.671L599.937 300.49L601.073 300.263L601.618 300.127L602.163 299.991C602.527 299.9 602.89 299.809 603.254 299.673C604.707 299.174 606.116 298.63 607.478 297.904C610.204 296.497 612.612 294.637 614.838 292.549C619.199 288.33 622.651 283.248 625.786 278.075C628.92 272.902 631.646 267.503 634.326 262.103C637.007 256.658 639.505 251.213 642.004 245.678L760.071 -18.9452Z"
          fill="#C6C6C6"
        />
        <path
          d="M772.199 -18.9452L650.634 252.484C648.09 258.11 645.501 263.737 642.775 269.318C640.095 274.899 637.279 280.389 634.144 285.743C632.599 288.42 630.919 291.007 629.147 293.548C627.375 296.043 625.422 298.493 623.241 300.671C621.061 302.849 618.699 304.8 616.018 306.298C615.382 306.706 614.655 306.978 613.974 307.341C613.247 307.614 612.566 307.931 611.839 308.204C610.385 308.703 608.886 309.066 607.387 309.338L606.251 309.519L605.116 309.61L604.525 309.656L603.934 309.701L602.799 309.746C601.254 309.746 599.71 309.701 598.211 309.565C595.167 309.293 592.123 308.703 589.125 307.977C583.129 306.479 577.314 304.437 571.499 302.214C565.73 299.991 560.006 297.586 554.327 295.136C548.649 292.686 542.97 290.19 537.337 287.649L401.735 226.984L266.133 166.318L232.244 151.163C220.932 146.127 209.666 141.045 198.309 136.053C192.63 133.558 186.952 131.108 181.228 128.748C175.504 126.389 169.735 124.12 163.829 122.169C157.924 120.263 151.882 118.584 145.613 118.04C142.478 117.768 139.298 117.858 136.209 118.448C134.665 118.766 133.12 119.174 131.621 119.719C130.167 120.309 128.713 120.944 127.351 121.806C124.625 123.439 122.172 125.481 119.991 127.75C117.811 130.019 115.903 132.514 114.086 135.055C110.497 140.182 107.499 145.627 104.637 151.163C101.775 156.699 99.0945 162.28 96.5051 167.906C93.9157 173.533 91.3717 179.204 88.8278 184.831L58.482 252.711L-2.30054 388.38L-0.665134 389.106L59.8448 253.255L90.0998 185.33C92.5983 179.658 95.1423 174.032 97.7317 168.405C100.321 162.779 102.956 157.198 105.818 151.708C108.634 146.217 111.678 140.818 115.176 135.781C116.948 133.286 118.81 130.835 120.945 128.612C123.08 126.434 125.397 124.438 127.987 122.895C129.259 122.124 130.667 121.488 132.075 120.944C133.483 120.399 134.937 119.991 136.436 119.719C139.389 119.174 142.478 119.083 145.522 119.31C151.609 119.809 157.606 121.443 163.466 123.349C169.326 125.254 175.095 127.523 180.819 129.837C186.543 132.197 192.222 134.647 197.9 137.142C209.212 142.134 220.523 147.17 231.835 152.207L265.769 167.316L401.462 227.8L537.155 288.284C542.834 290.78 548.467 293.321 554.146 295.726C559.824 298.176 565.548 300.535 571.317 302.759C577.132 304.937 582.992 307.024 588.989 308.476C591.987 309.202 595.076 309.792 598.165 310.064C599.71 310.245 601.254 310.245 602.844 310.245L604.025 310.2L604.616 310.155L605.206 310.109L606.388 309.973L607.523 309.792C609.068 309.519 610.567 309.156 612.066 308.612C612.793 308.385 613.52 308.067 614.247 307.75C614.928 307.387 615.655 307.069 616.336 306.661C619.062 305.118 621.515 303.122 623.696 300.898C625.876 298.675 627.83 296.225 629.647 293.729C631.464 291.188 633.099 288.556 634.644 285.879C637.778 280.525 640.595 274.99 643.275 269.409C645.955 263.827 648.545 258.201 651.089 252.529L772.199 -18.9452Z"
          fill="#C6C6C6"
        />
        <path
          d="M784.147 -18.5368L659.63 259.426C657.04 265.189 654.36 270.997 651.634 276.714C648.909 282.431 646.047 288.103 642.912 293.593C639.778 299.083 636.325 304.438 632.055 309.066C629.92 311.38 627.512 313.422 624.832 315.1C623.469 315.917 622.106 316.598 620.607 317.188C619.153 317.732 617.654 318.186 616.11 318.504C614.565 318.776 613.021 319.003 611.431 319.048C610.658 319.093 609.841 319.048 609.068 319.048C608.296 319.003 607.478 319.003 606.706 318.912C603.572 318.64 600.437 318.095 597.393 317.324C591.261 315.826 585.264 313.739 579.359 311.471C573.453 309.202 567.593 306.752 561.778 304.211C555.963 301.715 550.148 299.129 544.379 296.542L405.552 234.425L266.678 172.308L231.972 156.79C220.387 151.617 208.849 146.399 197.174 141.362C191.359 138.867 185.499 136.416 179.548 134.193C173.597 131.97 167.555 129.883 161.331 128.521C158.197 127.841 155.017 127.387 151.791 127.206C150.974 127.16 150.201 127.16 149.384 127.16C148.566 127.205 147.748 127.205 146.976 127.296C145.386 127.432 143.751 127.75 142.206 128.158C139.072 128.975 136.073 130.427 133.439 132.287C130.804 134.148 128.441 136.416 126.352 138.821C122.172 143.676 118.811 149.167 115.676 154.702C112.587 160.283 109.771 165.955 107.045 171.718C101.594 183.197 96.5057 194.813 91.3269 206.429L60.2088 275.942L-2.0274 414.969L-0.392001 415.695L61.6171 276.578L92.5989 207.019C97.7776 195.448 102.866 183.787 108.271 172.353C110.997 166.636 113.768 160.919 116.857 155.428C119.946 149.938 123.263 144.493 127.351 139.774C129.395 137.415 131.667 135.237 134.211 133.422C136.755 131.652 139.571 130.291 142.57 129.474C144.069 129.066 145.568 128.794 147.158 128.657C147.93 128.567 148.702 128.567 149.475 128.521C150.247 128.521 151.019 128.521 151.791 128.521C154.926 128.657 158.015 129.111 161.104 129.792C167.237 131.108 173.233 133.15 179.184 135.373C185.09 137.596 190.95 140.001 196.765 142.497C208.395 147.488 219.979 152.706 231.563 157.833L266.315 173.306L405.279 235.242L544.152 297.178C549.967 299.764 555.736 302.305 561.551 304.846C567.366 307.341 573.226 309.792 579.131 312.06C585.082 314.329 591.079 316.416 597.257 317.914C600.346 318.64 603.481 319.23 606.661 319.502C607.433 319.547 608.251 319.593 609.068 319.638C609.886 319.638 610.658 319.683 611.476 319.593C613.066 319.547 614.656 319.32 616.246 319.048C617.836 318.73 619.335 318.277 620.834 317.732C622.333 317.142 623.742 316.416 625.15 315.6C627.876 313.921 630.329 311.788 632.464 309.474C636.825 304.801 640.232 299.401 643.412 293.865C646.546 288.33 649.363 282.658 652.134 276.941C654.86 271.224 657.495 265.416 660.084 259.653L784.147 -18.5368Z"
          fill="#C6C6C6"
        />
        <path
          d="M796.549 -19.1268L668.942 265.779C666.262 271.723 663.582 277.621 660.811 283.52C658.04 289.373 655.178 295.226 652.043 300.898C648.909 306.57 645.501 312.151 641.277 317.052C639.187 319.502 636.779 321.725 634.145 323.585C632.827 324.493 631.419 325.31 629.965 325.99C628.511 326.625 626.967 327.17 625.422 327.578C623.878 327.941 622.288 328.214 620.652 328.304C619.062 328.395 617.427 328.44 615.837 328.35C612.612 328.168 609.432 327.624 606.252 326.898C599.937 325.446 593.805 323.313 587.763 320.999C581.721 318.685 575.724 316.144 569.773 313.603C563.822 311.017 557.871 308.385 551.966 305.753L409.549 241.957L267.224 178.297L231.654 162.37L213.846 154.43C207.895 151.798 201.944 149.212 195.902 146.762C189.86 144.311 183.818 141.952 177.549 140.046C174.414 139.093 171.28 138.231 168.055 137.596C166.465 137.278 164.829 137.006 163.194 136.825C161.558 136.643 159.923 136.507 158.242 136.507C157.424 136.462 156.607 136.552 155.744 136.552C155.335 136.598 154.926 136.643 154.517 136.689L153.881 136.734L153.245 136.825C151.61 137.052 149.974 137.46 148.384 137.959C145.204 139.003 142.297 140.682 139.708 142.723C137.118 144.811 134.847 147.215 132.757 149.756C130.713 152.297 128.85 155.02 127.124 157.788C123.672 163.323 120.628 169.131 117.766 174.985C114.904 180.838 112.178 186.736 109.453 192.68C106.772 198.625 104.138 204.569 101.457 210.467L93.5983 228.345L61.7079 299.582L-2.0274 442.012L-0.392001 442.738L63.1616 300.218L94.9611 228.935L102.911 211.102C105.546 205.158 108.181 199.214 110.861 193.316C113.541 187.417 116.267 181.473 119.129 175.665C121.991 169.857 124.989 164.095 128.396 158.604C130.122 155.882 131.939 153.205 133.938 150.664C135.937 148.168 138.163 145.809 140.662 143.812C143.16 141.816 145.931 140.228 148.929 139.23C150.429 138.73 151.973 138.322 153.563 138.141L154.154 138.05L154.744 138.004C155.153 137.959 155.516 137.914 155.925 137.914C156.743 137.868 157.515 137.823 158.333 137.823C159.923 137.823 161.513 137.959 163.103 138.095C164.693 138.277 166.283 138.549 167.873 138.867C171.007 139.502 174.142 140.319 177.231 141.271C183.409 143.177 189.451 145.491 195.493 147.941C201.489 150.392 207.441 152.978 213.392 155.564L231.199 163.459L266.815 179.34L409.231 242.819L551.602 306.252C557.553 308.884 563.459 311.516 569.455 314.102C575.406 316.689 581.403 319.184 587.49 321.498C593.577 323.812 599.756 325.945 606.07 327.397C609.25 328.123 612.475 328.667 615.746 328.849C617.382 328.94 619.017 328.94 620.652 328.803C622.288 328.667 623.923 328.395 625.513 328.032C627.103 327.624 628.648 327.079 630.147 326.399C631.646 325.718 633.054 324.901 634.417 323.948C637.097 322.043 639.505 319.819 641.64 317.324C645.91 312.378 649.317 306.752 652.452 301.08C655.586 295.363 658.448 289.509 661.22 283.656C663.991 277.757 666.671 271.859 669.306 265.915L796.549 -19.1268Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.683 -1.33996L671.985 285.925C669.26 291.869 666.443 297.813 663.49 303.666C660.492 309.474 657.358 315.237 653.633 320.636C651.77 323.313 649.771 325.9 647.5 328.259C645.228 330.573 642.73 332.706 639.868 334.294C638.46 335.065 636.96 335.746 635.416 336.245C633.871 336.744 632.281 337.152 630.691 337.379L630.101 337.47L629.51 337.515C629.101 337.561 628.693 337.606 628.284 337.606C627.466 337.652 626.648 337.697 625.831 337.652C624.195 337.652 622.56 337.515 620.97 337.334C614.474 336.517 608.205 334.657 602.026 332.524C595.848 330.392 589.761 327.941 583.764 325.4C571.726 320.319 559.779 314.874 547.786 309.565L404.279 245.36L260.772 181.156L224.884 165.138C218.888 162.507 212.891 159.875 206.849 157.334C200.807 154.838 194.675 152.388 188.451 150.301C182.227 148.259 175.822 146.444 169.19 145.945C165.873 145.718 162.512 145.809 159.241 146.58C157.606 146.943 156.016 147.442 154.471 148.123C152.926 148.804 151.427 149.575 150.065 150.528L149.519 150.891L149.02 151.254C148.702 151.481 148.338 151.753 148.02 151.98C147.384 152.524 146.703 153.023 146.112 153.613C144.84 154.702 143.705 155.927 142.614 157.153C140.434 159.648 138.48 162.325 136.663 165.093C133.029 170.629 129.94 176.437 126.987 182.29C124.034 188.189 121.263 194.133 118.538 200.077C115.812 206.066 113.132 212.055 110.451 218.045L94.3699 253.981L62.207 325.809L-2.1189 469.373L-0.483493 470.099L63.6152 326.353L95.6419 254.48L111.678 218.544C114.358 212.555 116.993 206.565 119.719 200.576C122.444 194.632 125.215 188.688 128.123 182.834C131.076 176.981 134.119 171.219 137.708 165.774C139.48 163.051 141.433 160.419 143.568 157.969C144.659 156.79 145.749 155.61 146.975 154.521C147.566 153.976 148.202 153.477 148.793 152.978C149.111 152.751 149.429 152.479 149.747 152.252L150.246 151.889L150.746 151.571C152.063 150.664 153.472 149.938 154.971 149.303C156.424 148.668 157.969 148.168 159.514 147.851C162.648 147.125 165.873 147.034 169.099 147.261C175.55 147.76 181.864 149.484 188.088 151.526C194.266 153.568 200.353 155.973 206.395 158.514C212.437 161.009 218.433 163.641 224.43 166.273L260.363 182.245L403.961 246.268L547.558 310.291C559.551 315.6 571.453 320.999 583.537 326.081C589.579 328.622 595.667 331.072 601.89 333.205C608.068 335.337 614.428 337.198 620.97 338.015C622.605 338.196 624.241 338.332 625.922 338.332C626.739 338.332 627.557 338.287 628.375 338.241C628.783 338.196 629.192 338.151 629.601 338.105L630.237 338.06L630.828 337.969C632.463 337.742 634.099 337.334 635.643 336.835C637.233 336.336 638.732 335.61 640.186 334.793C643.093 333.205 645.637 331.027 647.909 328.667C650.18 326.263 652.224 323.676 654.087 320.954C657.812 315.554 660.946 309.746 663.945 303.893C666.897 298.04 669.714 292.096 672.44 286.152L800.683 -1.33996Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.547 26.1115L736.221 169.676L704.058 241.458L687.977 277.349C685.296 283.338 682.616 289.328 679.89 295.272C677.165 301.216 674.348 307.16 671.395 312.968C668.397 318.776 665.263 324.538 661.538 329.938C659.675 332.615 657.676 335.201 655.405 337.561C653.133 339.875 650.589 342.007 647.773 343.55C644.956 345.138 641.822 346.182 638.596 346.636L638.006 346.726L637.415 346.772C637.006 346.817 636.598 346.862 636.189 346.862C635.371 346.908 634.553 346.953 633.736 346.908C632.1 346.908 630.465 346.772 628.875 346.59C622.424 345.773 616.11 343.913 609.931 341.781C603.753 339.648 597.666 337.198 591.669 334.657C585.628 332.116 579.631 329.484 573.68 326.807L537.792 310.79L394.376 246.676L250.915 182.517L232.971 174.531C226.975 171.899 220.978 169.267 214.936 166.726C208.894 164.231 202.807 161.781 196.538 159.693C190.314 157.606 183.909 155.837 177.276 155.292C175.641 155.201 173.96 155.111 172.279 155.201C171.871 155.201 171.462 155.247 171.053 155.292L169.826 155.428C169.009 155.564 168.191 155.655 167.373 155.837C166.555 155.973 165.738 156.245 164.92 156.472C164.148 156.744 163.33 157.016 162.558 157.334C161.786 157.652 161.013 158.015 160.286 158.423C159.56 158.831 158.833 159.24 158.151 159.693C157.424 160.147 156.788 160.646 156.107 161.145L155.153 161.917L154.653 162.325L154.199 162.734L153.29 163.596L152.427 164.458C151.837 165.048 151.292 165.683 150.701 166.273C148.521 168.768 146.522 171.445 144.705 174.168C141.07 179.658 137.981 185.466 135.028 191.365C132.076 197.218 129.305 203.162 126.579 209.151L-2.0274 496.28L-0.392001 497.006L127.76 209.651C130.486 203.706 133.257 197.762 136.164 191.909C139.117 186.056 142.161 180.293 145.749 174.848C147.521 172.126 149.475 169.494 151.61 167.089C152.155 166.5 152.7 165.864 153.29 165.32L154.154 164.458L155.062 163.641L155.516 163.233L155.971 162.87L156.925 162.098C157.561 161.645 158.197 161.145 158.878 160.692C159.56 160.238 160.241 159.875 160.922 159.467C161.649 159.104 162.331 158.741 163.103 158.423C163.83 158.105 164.602 157.833 165.329 157.606C166.101 157.379 166.873 157.152 167.646 157.016C168.418 156.835 169.236 156.744 170.008 156.608L171.189 156.472C171.598 156.426 172.007 156.381 172.37 156.381C173.96 156.29 175.596 156.336 177.186 156.426C183.636 156.971 189.951 158.695 196.129 160.737C202.307 162.824 208.395 165.229 214.436 167.725C220.478 170.22 226.475 172.852 232.471 175.484L250.415 183.47L393.967 247.447L537.519 311.425L573.407 327.397C579.404 330.029 585.4 332.66 591.442 335.201C597.484 337.742 603.572 340.192 609.75 342.325C615.928 344.458 622.288 346.318 628.829 347.135C630.465 347.316 632.1 347.452 633.736 347.452C634.553 347.452 635.371 347.407 636.189 347.407C636.598 347.362 637.006 347.316 637.415 347.316L638.051 347.271L638.642 347.18C641.913 346.726 645.093 345.637 648 344.049C650.907 342.461 653.451 340.283 655.768 337.924C658.04 335.564 660.084 332.933 661.946 330.255C665.671 324.856 668.806 319.048 671.804 313.24C674.757 307.387 677.574 301.443 680.299 295.499C683.025 289.555 685.705 283.565 688.34 277.576L704.376 241.639L736.403 169.812L800.547 26.1115Z"
          fill="#C6C6C6"
        />
        <path
          d="M801.001 52.2018L737.13 194.813L705.194 266.142L697.199 283.974C694.564 289.918 691.884 295.862 689.203 301.806C686.523 307.75 683.752 313.649 680.845 319.456C677.937 325.264 674.894 331.027 671.396 336.517C669.624 339.24 667.761 341.917 665.672 344.367C663.582 346.817 661.265 349.131 658.676 351.037C658.04 351.536 657.358 351.944 656.677 352.398C655.996 352.807 655.269 353.215 654.542 353.533C653.815 353.896 653.088 354.213 652.316 354.531C651.544 354.803 650.817 355.075 649.999 355.257C649.227 355.484 648.455 355.62 647.637 355.801C646.819 355.937 646.047 356.073 645.229 356.119C643.639 356.3 642.004 356.3 640.414 356.255C633.963 355.983 627.603 354.304 621.425 352.353C615.247 350.356 609.205 347.997 603.163 345.501C591.17 340.51 579.313 335.156 567.411 329.847L531.796 313.921L389.379 250.215L246.872 186.464C240.921 183.833 234.97 181.201 229.019 178.615C223.023 176.074 217.026 173.533 210.893 171.264C204.761 168.995 198.582 166.908 192.132 165.592C188.906 164.957 185.635 164.503 182.319 164.458C179.003 164.412 175.687 164.866 172.507 165.864C169.327 166.908 166.374 168.542 163.785 170.583C161.195 172.671 158.878 175.03 156.834 177.616C152.7 182.744 149.384 188.415 146.25 194.133C144.705 196.991 143.206 199.895 141.752 202.844C140.298 205.748 138.89 208.698 137.527 211.647C134.756 217.546 132.076 223.49 129.441 229.434L1.83435 514.747L3.46975 515.473L130.713 230.024C133.348 224.08 136.028 218.136 138.799 212.237C140.162 209.288 141.57 206.338 143.024 203.434C144.478 200.53 145.932 197.626 147.476 194.768C150.565 189.051 153.836 183.47 157.879 178.433C159.878 175.938 162.104 173.578 164.602 171.582C167.101 169.631 169.917 168.042 172.916 167.044C175.914 166.046 179.139 165.638 182.319 165.683C185.499 165.683 188.725 166.137 191.859 166.772C198.174 168.042 204.352 170.13 210.439 172.353C216.526 174.622 222.523 177.117 228.519 179.658C234.516 182.199 240.467 184.831 246.373 187.463L388.971 250.987L531.569 314.556L567.23 330.437C579.132 335.7 590.988 341.055 603.027 346.046C609.069 348.496 615.111 350.901 621.334 352.852C627.512 354.803 633.918 356.482 640.459 356.754C642.095 356.799 643.73 356.799 645.366 356.618C646.183 356.573 647.001 356.391 647.819 356.3C648.636 356.119 649.409 355.983 650.226 355.756C651.044 355.574 651.771 355.257 652.589 354.985C653.361 354.667 654.133 354.349 654.86 353.986C655.587 353.623 656.314 353.215 657.041 352.807C657.722 352.353 658.449 351.944 659.085 351.445C661.765 349.54 664.082 347.18 666.171 344.685C668.261 342.189 670.169 339.512 671.895 336.744C675.393 331.254 678.437 325.446 681.344 319.638C684.252 313.785 686.977 307.886 689.658 301.942C692.338 295.998 694.973 290.054 697.653 284.11L705.603 266.278L737.448 194.904L801.001 52.2018Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.819 79.6078L738.447 218.907L707.238 288.556C702.059 300.172 696.926 311.833 691.429 323.268C688.658 328.985 685.841 334.702 682.661 340.192C679.481 345.683 676.029 351.082 671.713 355.71C671.168 356.3 670.578 356.845 670.032 357.389L669.169 358.206L668.715 358.614L668.261 358.977C667.08 360.021 665.762 360.883 664.399 361.745C663.037 362.562 661.628 363.243 660.175 363.832C658.675 364.377 657.176 364.785 655.632 365.103C652.543 365.647 649.363 365.738 646.183 365.421C643.048 365.148 639.914 364.558 636.825 363.787C630.692 362.29 624.695 360.157 618.744 357.888C612.839 355.62 606.979 353.124 601.118 350.629C589.443 345.592 577.905 340.329 566.275 335.156L531.477 319.592L392.423 257.294L253.232 195.04C247.417 192.454 241.602 189.867 235.742 187.372C229.882 184.876 224.022 182.426 218.025 180.248C212.029 178.07 205.987 176.028 199.672 174.803C196.538 174.168 193.312 173.759 190.087 173.759C186.862 173.714 183.591 174.168 180.502 175.166C178.957 175.665 177.458 176.346 176.004 177.072C174.596 177.843 173.233 178.751 171.916 179.749C169.372 181.745 167.1 184.059 165.056 186.555C161.013 191.546 157.697 197.036 154.608 202.663C151.564 208.289 148.748 214.006 146.067 219.769C143.342 225.532 140.752 231.339 138.117 237.147L13.5088 515.746L15.1442 516.472L139.48 237.646C142.07 231.839 144.704 226.031 147.385 220.313C150.065 214.551 152.882 208.834 155.88 203.298C158.923 197.762 162.194 192.272 166.146 187.417C168.145 184.967 170.326 182.744 172.779 180.792C174.005 179.84 175.323 178.978 176.686 178.252C178.049 177.526 179.457 176.89 180.956 176.391C183.909 175.438 187.043 174.985 190.132 175.03C193.267 175.03 196.401 175.438 199.491 176.028C205.669 177.253 211.711 179.25 217.662 181.428C223.613 183.606 229.473 186.056 235.333 188.506C241.193 191.002 247.008 193.543 252.777 196.129L392.059 258.156L531.341 320.228L566.184 335.746C577.814 340.918 589.398 346.136 601.073 351.173C606.888 353.669 612.793 356.164 618.699 358.433C624.65 360.702 630.646 362.834 636.825 364.332C639.914 365.103 643.048 365.647 646.228 365.965C649.408 366.283 652.634 366.192 655.768 365.602C657.358 365.284 658.903 364.876 660.402 364.286C661.901 363.696 663.355 363.016 664.717 362.199C666.08 361.337 667.398 360.429 668.624 359.386L669.078 359.023L669.533 358.614L670.441 357.798C670.986 357.208 671.577 356.663 672.122 356.073C676.483 351.4 679.936 346 683.116 340.465C686.25 334.929 689.112 329.212 691.838 323.495C697.289 312.015 702.423 300.354 707.601 288.738L738.674 219.043L800.819 79.6078Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.774 106.832L739.946 242.728L709.555 310.654C707.011 316.326 704.467 321.952 701.832 327.578C699.198 333.205 696.517 338.786 693.61 344.276C690.703 349.721 687.613 355.121 683.888 360.112C682.026 362.562 680.027 364.967 677.756 367.054C677.165 367.553 676.62 368.098 676.029 368.551C675.439 369.05 674.803 369.504 674.212 369.958C672.94 370.82 671.623 371.637 670.26 372.272L669.76 372.544L669.215 372.771C668.852 372.907 668.488 373.089 668.17 373.225C667.443 373.497 666.717 373.724 665.99 373.951C665.263 374.178 664.491 374.314 663.764 374.495C663.4 374.586 662.991 374.632 662.628 374.677C662.265 374.722 661.856 374.813 661.492 374.813L660.357 374.904L659.221 374.949C658.449 374.995 657.676 374.949 656.904 374.949C655.36 374.904 653.815 374.768 652.316 374.586C646.183 373.769 640.232 372 634.372 370.003C631.465 369.005 628.557 367.916 625.65 366.782C622.742 365.647 619.88 364.468 617.064 363.288C611.34 360.883 605.662 358.433 600.028 355.892L532.159 325.537L396.284 264.78L260.5 204.024C254.822 201.529 249.189 198.988 243.465 196.583C237.741 194.133 232.017 191.773 226.202 189.64C220.388 187.508 214.437 185.511 208.349 184.241C205.306 183.606 202.171 183.152 199.037 183.061C195.902 183.016 192.722 183.243 189.678 184.15C188.906 184.332 188.179 184.604 187.407 184.876C187.044 185.012 186.68 185.194 186.317 185.33L185.772 185.557L185.226 185.829C183.773 186.51 182.455 187.326 181.138 188.234C178.549 190.094 176.232 192.227 174.187 194.632C170.054 199.396 166.783 204.705 163.739 210.15C160.695 215.595 157.924 221.176 155.244 226.757C152.564 232.383 149.974 238.009 147.43 243.681L25.7746 515.428L27.41 516.154L148.612 244.18C151.156 238.509 153.7 232.882 156.38 227.301C159.06 221.72 161.786 216.139 164.784 210.74C167.828 205.34 171.053 200.077 175.096 195.448C177.095 193.134 179.321 191.002 181.774 189.232C183 188.37 184.318 187.553 185.681 186.918L186.18 186.646L186.726 186.419C187.089 186.283 187.407 186.101 187.77 185.965C188.497 185.738 189.179 185.466 189.906 185.285C192.813 184.422 195.857 184.196 198.9 184.241C201.944 184.332 204.988 184.74 207.986 185.375C214.028 186.6 219.888 188.551 225.703 190.684C231.517 192.817 237.241 195.176 242.92 197.581C248.598 199.986 254.277 202.481 259.955 205.022L395.785 265.552L531.614 326.081L599.529 356.346C605.207 358.841 610.886 361.337 616.61 363.696C619.472 364.876 622.334 366.056 625.241 367.19C628.148 368.325 631.056 369.413 633.963 370.412C639.823 372.408 645.82 374.178 651.998 374.995C653.542 375.221 655.087 375.312 656.632 375.358C657.404 375.358 658.176 375.403 658.948 375.358L660.13 375.312L661.311 375.176C661.719 375.131 662.083 375.085 662.492 375.04C662.855 374.995 663.264 374.949 663.628 374.858C664.4 374.677 665.172 374.541 665.899 374.314C666.671 374.132 667.398 373.86 668.125 373.588C668.488 373.452 668.852 373.27 669.215 373.134L669.76 372.907L670.305 372.635C671.714 372 673.031 371.138 674.348 370.276C674.984 369.822 675.62 369.368 676.211 368.869C676.802 368.37 677.392 367.871 677.983 367.326C680.254 365.194 682.298 362.789 684.161 360.339C687.886 355.347 690.975 349.948 693.882 344.458C696.79 338.967 699.47 333.386 702.105 327.76C704.74 322.133 707.284 316.462 709.782 310.79L740.083 242.819L800.774 106.832Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.865 133.785L741.536 266.278L726.681 299.401C721.73 310.427 716.869 321.498 711.826 332.524C709.282 338.014 706.738 343.505 704.013 348.904C701.287 354.304 698.425 359.613 695.154 364.695C691.884 369.731 688.159 374.586 683.434 378.352C682.253 379.26 681.026 380.122 679.709 380.848L679.209 381.12L678.71 381.347L677.71 381.846C677.029 382.118 676.347 382.436 675.62 382.663C672.804 383.661 669.806 384.115 666.807 384.206C663.809 384.296 660.811 383.979 657.858 383.48C654.905 382.98 651.952 382.254 649.045 381.392C643.23 379.713 637.597 377.626 631.964 375.403C620.744 370.911 609.705 365.965 598.666 361.065L532.432 331.435L400.055 272.222L267.633 213.008C262.09 210.558 256.594 208.108 251.006 205.748C245.464 203.389 239.831 201.075 234.152 198.942C228.474 196.855 222.704 194.904 216.753 193.633C213.755 192.998 210.757 192.544 207.668 192.408C204.624 192.272 201.49 192.499 198.491 193.18C195.493 193.906 192.586 195.131 190.042 196.855C187.452 198.534 185.136 200.621 183.046 202.844C178.912 207.382 175.596 212.509 172.552 217.773C169.508 223.036 166.783 228.436 164.148 233.926C161.513 239.371 158.969 244.906 156.471 250.397L37.9038 515.428L39.5392 516.154L157.743 250.941C160.241 245.451 162.74 239.915 165.374 234.47C168.009 229.025 170.69 223.626 173.688 218.408C176.686 213.19 179.957 208.108 184 203.707C185.999 201.529 188.225 199.487 190.723 197.899C193.176 196.265 195.947 195.085 198.809 194.405C201.671 193.724 204.67 193.497 207.622 193.633C210.575 193.77 213.573 194.223 216.481 194.813C222.341 196.084 228.065 197.989 233.743 200.031C239.376 202.118 244.964 204.387 250.552 206.747C256.094 209.106 261.636 211.511 267.178 213.961L399.646 272.993L532.114 332.025L598.348 361.518C609.387 366.419 620.426 371.365 631.692 375.811C637.325 378.035 643.003 380.122 648.818 381.801C651.725 382.617 654.678 383.343 657.676 383.888C660.675 384.387 663.718 384.705 666.762 384.614C669.806 384.523 672.849 384.069 675.711 383.026C676.438 382.799 677.12 382.481 677.846 382.164L678.891 381.665L679.391 381.392L679.891 381.12C681.253 380.394 682.48 379.487 683.707 378.579C688.477 374.768 692.202 369.867 695.518 364.831C698.789 359.703 701.651 354.395 704.376 348.995C707.102 343.596 709.646 338.105 712.19 332.615C717.232 321.589 722.048 310.518 726.999 299.492L741.763 266.323L800.865 133.785Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.593 161.508L742.854 290.508L728.408 322.769C723.592 333.522 718.822 344.276 713.644 354.848C711.054 360.112 708.329 365.375 705.33 370.412C702.332 375.448 699.016 380.349 694.882 384.523C692.792 386.61 690.566 388.471 688.022 389.923C686.75 390.694 685.433 391.284 684.07 391.783C683.389 392.01 682.707 392.282 681.98 392.464C681.617 392.554 681.299 392.691 680.936 392.736L679.845 392.963C676.983 393.553 674.031 393.598 671.123 393.417C668.216 393.235 665.308 392.736 662.446 392.101C656.722 390.83 651.135 388.924 645.638 386.883C640.141 384.841 634.69 382.572 629.284 380.303C618.472 375.675 607.751 370.82 596.985 366.056L532.568 337.198L403.689 279.572L274.81 221.947C269.45 219.542 264.044 217.183 258.638 214.869C253.232 212.555 247.781 210.331 242.239 208.289C236.696 206.248 231.109 204.342 225.294 203.071C222.387 202.436 219.479 201.937 216.481 201.755C213.528 201.574 210.484 201.665 207.532 202.255L206.441 202.481C206.078 202.572 205.715 202.663 205.351 202.799C204.624 202.981 203.943 203.253 203.216 203.48L202.171 203.933L201.671 204.16L201.172 204.387L200.172 204.886L199.173 205.431L198.673 205.703L198.219 206.021L197.265 206.656C196.674 207.11 196.038 207.518 195.448 208.017L194.585 208.743C194.312 208.97 194.04 209.242 193.767 209.469C193.222 209.968 192.677 210.513 192.132 211.012C190.042 213.144 188.134 215.459 186.408 217.863C184.681 220.268 183.091 222.764 181.592 225.305C178.549 230.387 175.868 235.65 173.279 240.959C170.69 246.268 168.191 251.622 165.783 256.976L50.2603 514.974L51.8957 515.7L166.965 257.52C169.418 252.166 171.871 246.812 174.46 241.549C177.05 236.285 179.73 231.022 182.728 225.985C184.227 223.444 185.772 220.994 187.498 218.635C189.179 216.275 191.041 214.007 193.086 211.919C193.585 211.42 194.085 210.876 194.63 210.422C194.903 210.195 195.175 209.923 195.448 209.696L196.266 209.015C196.811 208.562 197.401 208.153 197.992 207.699L198.9 207.11L199.355 206.792L199.809 206.52L200.763 205.975L201.717 205.476L202.217 205.249L202.716 205.022L203.716 204.614C204.397 204.387 205.079 204.115 205.76 203.933C206.123 203.843 206.441 203.752 206.805 203.661L207.85 203.434C210.666 202.844 213.574 202.754 216.481 202.935C219.388 203.117 222.25 203.57 225.112 204.206C230.836 205.476 236.378 207.337 241.875 209.333C247.372 211.375 252.823 213.598 258.229 215.867C263.635 218.181 269.041 220.54 274.401 222.9L403.371 280.344L532.341 337.788L596.803 366.51C607.569 371.274 618.291 376.129 629.102 380.712C634.508 383.026 639.96 385.249 645.502 387.291C651.044 389.333 656.632 391.193 662.401 392.464C665.263 393.099 668.216 393.598 671.169 393.78C674.121 393.961 677.12 393.87 680.027 393.28L681.117 393.054C681.481 392.963 681.844 392.872 682.207 392.781C682.934 392.6 683.616 392.328 684.343 392.101C685.705 391.556 687.068 390.966 688.34 390.195C690.93 388.743 693.201 386.792 695.291 384.705C699.47 380.485 702.741 375.539 705.785 370.503C708.783 365.421 711.508 360.203 714.098 354.894C719.277 344.322 724.001 333.522 728.817 322.769L743.217 290.508L800.593 161.508Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.592 188.597L744.353 314.193L730.27 345.592C727.908 350.81 725.5 356.028 723.002 361.201C720.503 366.373 717.959 371.501 715.143 376.492C712.326 381.483 709.282 386.384 705.648 390.739C703.831 392.917 701.832 394.959 699.606 396.774C697.38 398.589 694.882 399.996 692.247 401.039C689.612 402.038 686.796 402.627 683.934 402.809C681.072 402.99 678.255 402.809 675.393 402.401C669.76 401.584 664.218 399.95 658.812 398.135C653.406 396.275 648.046 394.188 642.776 392.01C637.461 389.832 632.237 387.563 626.967 385.249C616.473 380.621 606.025 375.947 595.576 371.228L532.886 343.142L407.414 287.014L281.897 230.84C271.403 226.212 260.909 221.584 250.143 217.546C244.737 215.549 239.286 213.734 233.652 212.464C230.836 211.829 227.974 211.329 225.067 211.103C222.159 210.876 219.252 210.921 216.344 211.42C213.437 211.874 210.666 212.872 208.031 214.188C205.442 215.595 203.08 217.364 200.99 219.361C196.765 223.399 193.449 228.163 190.405 233.064C187.407 237.964 184.727 243.091 182.137 248.219C179.593 253.346 177.14 258.564 174.733 263.782L62.344 514.974L63.9794 515.7L176.05 264.327C178.412 259.109 180.865 253.936 183.409 248.809C185.953 243.681 188.633 238.599 191.586 233.744C194.585 228.889 197.855 224.216 201.944 220.268C203.988 218.317 206.259 216.638 208.713 215.277C211.211 214.007 213.846 213.054 216.617 212.6C219.388 212.146 222.205 212.055 225.021 212.282C227.838 212.509 230.654 212.963 233.425 213.598C238.968 214.869 244.373 216.684 249.779 218.635C260.5 222.628 270.994 227.256 281.488 231.839L407.051 287.83L532.613 343.777L595.395 371.773C605.843 376.447 616.337 381.12 626.831 385.703C632.1 388.017 637.325 390.286 642.64 392.464C647.955 394.642 653.27 396.729 658.721 398.589C664.173 400.404 669.669 402.038 675.393 402.809C678.255 403.217 681.117 403.399 683.979 403.217C686.841 403.036 689.703 402.446 692.383 401.402C695.063 400.313 697.607 398.861 699.833 397.046C702.059 395.231 704.104 393.19 705.921 390.966C709.6 386.52 712.644 381.619 715.461 376.628C718.277 371.637 720.821 366.464 723.32 361.292C725.818 356.119 728.18 350.901 730.543 345.683L744.534 314.238L800.592 188.597Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.864 215.141L746.124 337.47C741.581 347.679 737.038 357.888 732.268 367.961C729.861 372.998 727.407 378.035 724.773 382.935C722.138 387.835 719.276 392.645 715.96 397.137C714.324 399.361 712.507 401.493 710.554 403.49C708.555 405.441 706.42 407.21 704.012 408.572L703.103 409.071L702.149 409.524C701.559 409.842 700.878 410.069 700.242 410.341C698.924 410.795 697.607 411.249 696.244 411.521C694.881 411.838 693.518 411.975 692.155 412.111C691.474 412.156 690.793 412.201 690.066 412.201C689.384 412.201 688.657 412.201 687.976 412.156C682.434 411.884 676.982 410.613 671.622 409.025C666.307 407.437 661.083 405.486 655.858 403.444C645.501 399.315 635.325 394.778 625.104 390.24L594.576 376.583L533.476 349.222L411.275 294.546L289.074 239.87C278.853 235.378 268.631 230.84 258.183 226.938C252.959 224.987 247.644 223.217 242.147 221.947C239.421 221.312 236.65 220.813 233.833 220.54C231.017 220.268 228.155 220.223 225.338 220.631C222.522 221.039 219.751 221.765 217.161 223.036C214.572 224.261 212.21 225.894 210.075 227.755C205.804 231.521 202.443 236.104 199.399 240.823C197.9 243.182 196.492 245.632 195.129 248.083C193.766 250.533 192.449 253.028 191.222 255.524C188.678 260.515 186.27 265.552 183.954 270.634C179.275 280.797 174.777 291.007 170.189 301.17L156.561 331.662L129.168 392.827L74.427 515.11L76.0624 515.836L130.621 393.416L157.878 332.207L171.506 301.624C176.049 291.415 180.547 281.206 185.18 271.042C187.497 265.96 189.905 260.923 192.403 255.978C193.675 253.482 194.947 251.032 196.31 248.582C197.673 246.131 199.036 243.727 200.535 241.412C203.533 236.739 206.849 232.247 210.938 228.617C212.982 226.802 215.253 225.259 217.707 224.08C220.16 222.9 222.794 222.174 225.52 221.765C228.246 221.402 230.972 221.448 233.743 221.675C236.468 221.947 239.194 222.446 241.92 223.036C247.326 224.306 252.595 226.076 257.819 227.982C268.268 231.884 278.489 236.331 288.665 240.823L410.957 295.272L533.249 349.812L594.395 377.036L624.967 390.649C635.189 395.186 645.365 399.678 655.768 403.807C660.946 405.849 666.216 407.8 671.577 409.388C676.937 410.976 682.434 412.247 688.021 412.519C688.703 412.564 689.43 412.564 690.111 412.564C690.793 412.564 691.519 412.519 692.201 412.474C693.609 412.338 695.017 412.201 696.38 411.884C697.743 411.612 699.106 411.158 700.423 410.704C701.059 410.432 701.741 410.205 702.331 409.842L703.285 409.388L704.194 408.844C706.647 407.437 708.827 405.668 710.826 403.671C712.825 401.72 714.597 399.542 716.278 397.273C719.594 392.781 722.41 387.926 725.091 383.026C727.725 378.125 730.178 373.089 732.586 368.052C737.356 357.934 741.853 347.725 746.396 337.515L800.864 215.141Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.728 242.502L747.532 361.428C743.08 371.319 738.538 381.211 733.495 390.785C730.951 395.549 728.271 400.313 725.136 404.715C722.047 409.116 718.504 413.336 714.097 416.467C711.917 418.055 709.464 419.235 706.92 420.097C704.376 420.959 701.65 421.322 698.97 421.458C693.564 421.639 688.204 420.641 682.979 419.235C677.755 417.828 672.622 416.058 667.579 414.107C662.537 412.202 657.494 410.114 652.543 407.982C642.594 403.717 632.691 399.27 622.787 394.823L593.078 381.528L533.703 354.939L414.864 301.806L296.07 248.672C286.167 244.317 276.218 239.915 265.997 236.149C263.453 235.196 260.863 234.334 258.274 233.472C255.685 232.655 253.05 231.884 250.415 231.249C245.1 229.978 239.603 229.162 234.106 229.751C231.335 230.024 228.655 230.75 226.066 231.839C223.522 232.928 221.16 234.425 219.024 236.195C214.754 239.734 211.347 244.09 208.349 248.627C205.351 253.165 202.716 257.974 200.217 262.784C197.719 267.594 195.356 272.539 193.085 277.44C188.497 287.286 184.09 297.223 179.684 307.115L166.374 336.835L139.753 396.275L86.4659 515.247L88.1013 515.973L141.161 397.001L167.645 337.47L180.91 307.704C185.317 297.768 189.678 287.831 194.266 278.03C196.538 273.129 198.9 268.229 201.353 263.419C203.852 258.609 206.441 253.845 209.394 249.353C212.347 244.861 215.663 240.551 219.797 237.147C221.841 235.469 224.112 234.017 226.52 232.973C228.973 231.929 231.517 231.249 234.197 230.977C239.512 230.387 244.873 231.203 250.097 232.428C252.732 233.064 255.321 233.79 257.865 234.606C260.455 235.423 262.999 236.331 265.543 237.238C275.673 241.004 285.622 245.36 295.57 249.716L414.455 302.668L533.34 355.62L592.76 382.118L622.469 395.368C632.373 399.769 642.276 404.216 652.27 408.481C657.267 410.613 662.264 412.655 667.352 414.606C672.44 416.512 677.573 418.327 682.798 419.688C688.022 421.05 693.428 422.093 698.925 421.866C701.65 421.775 704.376 421.367 706.965 420.505C709.555 419.643 712.008 418.418 714.234 416.83C718.686 413.653 722.229 409.434 725.364 404.987C728.453 400.54 731.178 395.776 733.722 391.012C738.765 381.392 743.262 371.501 747.714 361.609L800.728 242.502Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.865 269.318L775.016 327.125L762.069 356.028C757.754 365.647 753.483 375.312 748.986 384.886C746.76 389.65 744.443 394.415 741.99 399.088C740.764 401.402 739.492 403.762 738.174 406.031C736.857 408.299 735.494 410.568 733.995 412.746C731.042 417.102 727.771 421.276 723.637 424.589C719.594 427.946 714.597 430.079 709.373 430.623C704.149 431.213 698.879 430.487 693.746 429.308C691.202 428.718 688.658 427.992 686.114 427.22C683.615 426.449 681.117 425.587 678.618 424.679C673.667 422.864 668.806 420.913 663.945 418.871C659.084 416.83 654.269 414.742 649.453 412.61L418.544 309.202L303.021 257.52C293.39 253.255 283.714 249.035 273.765 245.36C271.266 244.453 268.768 243.591 266.269 242.774C263.725 241.957 261.181 241.231 258.638 240.596C253.504 239.371 248.144 238.509 242.783 238.962C240.103 239.189 237.423 239.779 234.924 240.732C232.426 241.73 230.063 243.091 227.928 244.725C225.793 246.358 223.885 248.219 222.114 250.261C220.342 252.257 218.752 254.39 217.253 256.568C214.254 260.969 211.62 265.552 209.167 270.225C206.713 274.899 204.397 279.663 202.125 284.427C197.628 294.001 193.358 303.621 189.042 313.285L176.095 342.189L150.201 399.996L98.4134 515.655L100.049 516.381L151.609 400.676L177.367 342.824L190.269 313.921C194.539 304.256 198.809 294.637 203.306 285.063C205.532 280.298 207.849 275.534 210.302 270.906C212.755 266.232 215.345 261.695 218.298 257.339C219.751 255.161 221.341 253.074 223.067 251.123C224.794 249.172 226.656 247.311 228.701 245.769C230.745 244.18 233.016 242.91 235.378 241.957C237.786 241.004 240.33 240.46 242.874 240.233C248.053 239.779 253.277 240.596 258.32 241.776C260.863 242.365 263.407 243.091 265.906 243.908C268.405 244.725 270.903 245.587 273.356 246.495C283.214 250.124 292.89 254.344 302.566 258.564L418.18 310.019L649.363 412.973C654.178 415.105 659.039 417.193 663.9 419.234C668.76 421.276 673.667 423.227 678.618 425.042C681.117 425.95 683.615 426.812 686.114 427.583C688.612 428.355 691.156 429.081 693.746 429.671C698.879 430.85 704.194 431.576 709.509 430.941C714.779 430.351 719.867 428.173 723.955 424.816C728.089 421.458 731.405 417.238 734.313 412.882C735.812 410.704 737.175 408.435 738.492 406.121C739.81 403.853 741.082 401.493 742.308 399.179C744.761 394.505 747.033 389.741 749.304 384.977C753.756 375.403 758.026 365.738 762.342 356.119L775.243 327.17L800.865 269.318Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.91 296.406L775.789 352.534L763.251 380.576C759.026 389.923 754.756 399.224 750.031 408.299C748.85 410.568 747.623 412.837 746.351 415.015C745.079 417.238 743.762 419.416 742.308 421.549C739.492 425.814 736.312 429.897 732.451 433.21C728.589 436.522 723.865 438.927 718.822 439.653C713.78 440.47 708.601 439.971 703.649 438.927C698.652 437.929 693.746 436.386 688.931 434.707C684.115 433.028 679.345 431.123 674.621 429.171C665.172 425.269 655.814 421.095 646.456 416.92L422.178 316.598L310.062 266.414C300.704 262.285 291.301 258.201 281.67 254.617C279.262 253.709 276.854 252.892 274.401 252.076C271.948 251.304 269.495 250.578 266.997 249.943C262 248.718 256.821 247.901 251.597 248.173C249.007 248.309 246.418 248.809 243.919 249.625C241.421 250.487 239.104 251.667 236.969 253.165C232.699 256.205 229.246 260.152 226.202 264.327C223.204 268.546 220.569 272.993 218.116 277.485C215.663 282.023 213.392 286.605 211.166 291.234C206.759 300.49 202.58 309.837 198.401 319.23L185.862 347.271L160.741 403.399L110.498 515.791L112.133 516.517L162.195 404.17L187.18 348.042L199.673 319.956C203.852 310.608 207.986 301.216 212.392 291.96C214.573 287.331 216.844 282.749 219.297 278.257C221.705 273.764 224.294 269.363 227.247 265.234C230.2 261.105 233.562 257.248 237.65 254.344C241.739 251.44 246.645 249.761 251.642 249.489C256.684 249.217 261.727 249.988 266.633 251.213C269.086 251.803 271.539 252.529 273.992 253.301C276.4 254.072 278.808 254.934 281.216 255.796C290.801 259.335 300.204 263.419 309.563 267.503L421.769 317.46L646.183 417.42C655.541 421.549 664.899 425.723 674.348 429.625C679.073 431.576 683.843 433.437 688.704 435.161C693.519 436.84 698.425 438.382 703.468 439.381C708.465 440.379 713.689 440.923 718.777 440.061C719.413 439.971 720.049 439.834 720.685 439.698C721.321 439.562 721.911 439.381 722.547 439.199C723.138 438.972 723.774 438.791 724.364 438.564C724.955 438.292 725.546 438.065 726.136 437.793C728.453 436.658 730.588 435.206 732.541 433.527C736.448 430.17 739.628 426.041 742.445 421.775C743.853 419.643 745.216 417.465 746.488 415.242C747.76 413.018 748.986 410.75 750.167 408.481C754.892 399.361 759.117 390.059 763.342 380.712L775.834 352.625L800.91 296.406Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.819 323.722L776.515 378.08C772.472 387.155 768.428 396.184 764.158 405.168C762.023 409.661 759.843 414.107 757.526 418.509C755.209 422.864 752.756 427.22 749.985 431.304C747.214 435.388 744.125 439.335 740.354 442.557C738.491 444.145 736.402 445.552 734.221 446.641C731.995 447.73 729.633 448.501 727.225 448.955C722.365 449.817 717.368 449.408 712.507 448.501C707.646 447.548 702.876 446.141 698.197 444.553C688.839 441.332 679.708 437.43 670.622 433.482C661.537 429.534 652.497 425.451 643.456 421.412L426.311 324.175L372.025 299.855L344.859 287.694C335.819 283.656 326.779 279.572 317.693 275.579C308.608 271.587 299.522 267.639 290.209 264.145C285.53 262.421 280.851 260.833 275.99 259.562C271.175 258.337 266.178 257.384 261.135 257.475C258.637 257.52 256.093 257.838 253.64 258.473C251.187 259.109 248.824 260.152 246.644 261.423C244.463 262.739 242.465 264.327 240.647 266.051C238.83 267.82 237.195 269.681 235.65 271.677C232.607 275.67 229.972 279.89 227.519 284.246C225.066 288.602 222.84 293.003 220.659 297.495C216.298 306.434 212.255 315.509 208.167 324.538L195.992 351.718L171.643 406.076L123.035 514.793L124.67 515.519L173.142 406.711L197.355 352.307L209.439 325.083C213.482 316.008 217.525 306.978 221.84 298.04C224.021 293.593 226.247 289.192 228.654 284.836C231.062 280.525 233.652 276.305 236.65 272.403C239.648 268.546 243.101 264.916 247.235 262.421C249.324 261.196 251.55 260.198 253.867 259.608C256.184 258.972 258.637 258.655 261.045 258.655C265.905 258.564 270.812 259.472 275.581 260.697C280.351 261.922 285.03 263.51 289.664 265.189C298.931 268.637 308.017 272.585 317.103 276.532C326.188 280.525 335.228 284.564 344.268 288.602L371.434 300.717L425.766 324.901L643.275 421.821C652.315 425.859 661.4 429.897 670.486 433.845C679.572 437.793 688.703 441.649 698.106 444.871C702.785 446.459 707.555 447.866 712.461 448.819C717.322 449.726 722.365 450.134 727.316 449.227C729.769 448.773 732.177 448.002 734.403 446.867C736.629 445.778 738.719 444.326 740.581 442.738C744.352 439.471 747.441 435.524 750.212 431.395C752.983 427.266 755.391 422.91 757.753 418.554C760.07 414.153 762.25 409.706 764.34 405.214C768.565 396.23 772.608 387.155 776.605 378.08L800.819 323.722Z"
          fill="#C6C6C6"
        />
        <path
          d="M800.547 351.445L788.781 377.762C784.829 386.52 780.968 395.322 776.97 404.079C772.972 412.837 768.929 421.549 764.341 429.988C762.024 434.208 759.617 438.337 756.845 442.285C754.074 446.187 750.985 449.908 747.169 452.857C745.261 454.309 743.217 455.579 741.036 456.532C738.856 457.485 736.539 458.12 734.131 458.438C729.407 459.118 724.546 458.619 719.867 457.712C717.505 457.258 715.188 456.668 712.871 455.988C710.554 455.352 708.283 454.581 706.012 453.81C701.469 452.222 697.017 450.497 692.565 448.682C683.661 445.052 674.894 441.15 666.126 437.248L639.823 425.496L429.447 331.299L376.841 307.75L350.538 295.998C341.771 292.096 333.003 288.148 324.236 284.291C315.423 280.434 306.61 276.623 297.57 273.265C293.072 271.632 288.484 270.044 283.805 268.864C279.126 267.684 274.31 266.777 269.45 266.822C266.997 266.822 264.543 267.094 262.181 267.684C259.774 268.274 257.502 269.182 255.367 270.407C251.051 272.812 247.508 276.305 244.464 280.071C242.92 281.977 241.512 283.928 240.194 285.97C238.877 287.967 237.605 290.054 236.378 292.141C233.971 296.315 231.745 300.581 229.609 304.937C225.339 313.558 221.387 322.36 217.435 331.118L205.669 357.435L182.092 410.069L134.938 515.337L136.573 516.063L183.546 410.659L206.986 357.979L218.707 331.617C222.614 322.859 226.566 314.057 230.791 305.481C232.926 301.171 235.106 296.905 237.514 292.776C238.695 290.689 239.922 288.647 241.239 286.651C242.556 284.654 243.919 282.703 245.418 280.843C248.371 277.167 251.824 273.764 255.912 271.45C257.956 270.316 260.137 269.408 262.408 268.864C264.68 268.319 267.042 268.047 269.404 268.047C271.767 268.047 274.129 268.229 276.491 268.592C278.853 268.955 281.17 269.454 283.487 270.044C288.121 271.223 292.663 272.766 297.161 274.4C306.155 277.712 314.968 281.523 323.781 285.335C332.594 289.192 341.362 293.094 350.13 296.996L376.432 308.703L429.083 332.161L639.641 425.95L665.944 437.656C674.712 441.559 683.525 445.415 692.429 449.045C696.881 450.86 701.378 452.585 705.921 454.127C708.192 454.899 710.464 455.625 712.78 456.305C715.097 456.986 717.414 457.576 719.776 458.03C724.501 458.937 729.362 459.436 734.131 458.756C736.539 458.393 738.856 457.757 741.082 456.804C743.308 455.852 745.352 454.581 747.26 453.084C751.076 450.089 754.165 446.368 756.936 442.421C759.707 438.473 762.115 434.299 764.432 430.079C768.975 421.594 773.018 412.882 777.015 404.125C780.968 395.368 784.874 386.565 788.781 377.808L800.547 351.445Z"
          fill="#919191"
        />
        <path
          d="M801.047 377.536L789.644 403.081C785.828 411.566 782.012 420.097 777.924 428.445C775.88 432.62 773.745 436.794 771.519 440.878C769.247 444.962 766.839 448.955 764.068 452.721C761.343 456.487 758.208 459.981 754.438 462.748C752.575 464.11 750.531 465.289 748.396 466.152C746.261 467.014 743.989 467.603 741.672 467.876C737.039 468.466 732.36 467.966 727.817 467.059C725.545 466.605 723.274 466.015 721.048 465.38C718.822 464.745 716.596 464.019 714.37 463.293C705.557 460.253 696.971 456.623 688.431 452.948C679.89 449.227 671.395 445.415 662.9 441.604L637.415 430.17L433.399 338.831L382.383 316.008L356.898 304.574C348.403 300.762 339.908 296.951 331.368 293.23C322.827 289.509 314.287 285.789 305.519 282.567C301.113 280.979 296.706 279.436 292.163 278.257C289.892 277.667 287.621 277.122 285.304 276.759C282.987 276.396 280.625 276.124 278.263 276.079C275.9 276.033 273.538 276.215 271.176 276.668C268.859 277.122 266.588 277.939 264.452 278.983C260.182 281.115 256.593 284.382 253.504 287.921C250.415 291.506 247.826 295.453 245.418 299.446C243.011 303.485 240.83 307.614 238.695 311.788C234.47 320.137 230.609 328.622 226.793 337.107L215.39 362.653L192.54 413.699L146.84 515.836L148.475 516.562L193.994 414.379L216.753 363.288L228.11 337.742C231.926 329.257 235.787 320.772 239.921 312.423C242.011 308.294 244.192 304.165 246.554 300.172C248.916 296.179 251.506 292.323 254.504 288.829C257.502 285.335 260.955 282.204 265.043 280.162C267.087 279.119 269.222 278.393 271.448 277.939C273.674 277.485 275.946 277.304 278.263 277.349C282.851 277.44 287.439 278.257 291.891 279.436C296.388 280.571 300.795 282.068 305.156 283.656C313.878 286.878 322.418 290.553 330.959 294.228C339.499 297.949 347.994 301.76 356.489 305.526L382.02 316.87L433.081 339.603L637.234 430.578L662.764 441.922C671.259 445.688 679.8 449.499 688.34 453.22C696.88 456.895 705.512 460.525 714.325 463.52C716.551 464.246 718.731 464.972 721.003 465.607C723.229 466.242 725.5 466.832 727.817 467.241C732.405 468.148 737.084 468.647 741.718 468.012C744.035 467.694 746.306 467.15 748.487 466.242C750.667 465.38 752.711 464.2 754.574 462.794C758.344 460.026 761.479 456.487 764.205 452.721C766.93 448.955 769.383 444.962 771.609 440.878C773.881 436.794 775.97 432.62 778.015 428.445C782.103 420.051 785.919 411.566 789.69 403.036L801.047 377.536Z"
          fill="#919191"
        />
        <path
          d="M802 402.537C798.321 410.795 794.641 419.053 790.871 427.22C787.055 435.433 783.193 443.601 778.741 451.45C776.515 455.398 774.108 459.209 771.427 462.839C768.702 466.424 765.613 469.781 761.933 472.368C760.07 473.684 758.117 474.727 755.982 475.544C753.892 476.361 751.666 476.86 749.44 477.132C744.943 477.677 740.446 477.178 735.994 476.361C733.768 475.907 731.587 475.363 729.407 474.773C727.226 474.137 725.091 473.502 722.956 472.776C718.686 471.324 714.461 469.736 710.282 468.057C701.923 464.7 693.655 461.07 685.387 457.394L636.007 435.297L438.305 346.772L388.879 324.629L364.166 313.558C355.944 309.882 347.676 306.162 339.408 302.532C331.14 298.902 322.827 295.317 314.378 292.141C310.153 290.553 305.837 289.101 301.476 287.876C299.295 287.286 297.069 286.742 294.844 286.288C292.618 285.879 290.346 285.562 288.075 285.426C285.803 285.29 283.487 285.335 281.215 285.607C278.944 285.925 276.672 286.469 274.537 287.331C270.222 289.056 266.497 291.914 263.317 295.227C261.727 296.86 260.273 298.675 258.91 300.49C257.547 302.305 256.275 304.211 255.049 306.116C252.596 309.973 250.415 313.921 248.325 317.959C244.146 325.99 240.375 334.203 236.605 342.416C232.88 350.629 229.2 358.932 225.521 367.145L203.352 416.603L159.06 515.61L160.695 516.336L204.805 417.283L226.838 367.78C230.518 359.522 234.152 351.264 237.877 343.006C241.602 334.793 245.373 326.58 249.507 318.549C251.596 314.556 253.731 310.608 256.139 306.797C257.32 304.891 258.592 303.031 259.909 301.261C261.272 299.492 262.635 297.722 264.18 296.134C267.223 292.912 270.812 290.19 274.946 288.557C279.035 286.878 283.532 286.424 287.938 286.696C290.164 286.832 292.39 287.15 294.571 287.558C296.752 287.967 298.932 288.511 301.113 289.101C305.428 290.281 309.698 291.733 313.923 293.321C322.373 296.452 330.641 300.036 338.909 303.621C347.176 307.251 355.399 310.926 363.667 314.601L388.38 325.627L437.941 347.588L635.825 435.705L685.296 457.712C693.564 461.342 701.832 464.972 710.191 468.33C714.37 470.008 718.595 471.596 722.91 473.048C725.046 473.774 727.226 474.41 729.361 475.045C731.542 475.635 733.722 476.179 735.948 476.633C740.4 477.45 744.943 477.949 749.44 477.404C751.666 477.132 753.892 476.588 756.027 475.771C758.162 474.954 760.161 473.865 761.978 472.549C765.658 469.918 768.793 466.56 771.473 462.93C774.199 459.3 776.561 455.443 778.787 451.541C783.239 443.646 787.1 435.479 790.871 427.311C794.687 419.098 798.321 410.795 802 402.537Z"
          fill="#919191"
        />
        <path
          d="M801.001 431.849C797.367 439.744 793.733 447.639 789.69 455.352C787.645 459.209 785.556 462.975 783.193 466.651C780.877 470.326 778.287 473.865 775.289 476.996C772.291 480.127 768.793 482.849 764.795 484.573C760.797 486.298 756.391 486.888 752.075 486.751C747.76 486.57 743.444 485.753 739.265 484.71C735.085 483.621 730.951 482.259 726.863 480.762C718.686 477.767 710.69 474.364 702.741 470.916C694.791 467.422 686.841 463.883 678.936 460.344L631.373 439.018L441.031 353.759L393.468 332.433L369.663 321.77C361.713 318.231 353.809 314.647 345.859 311.198C337.909 307.704 329.914 304.301 321.737 301.261C317.648 299.764 313.514 298.357 309.29 297.178C307.2 296.633 305.065 296.089 302.884 295.68C300.749 295.272 298.569 294.954 296.343 294.818C291.982 294.501 287.439 294.864 283.26 296.406C279.035 297.904 275.355 300.535 272.221 303.621C270.631 305.163 269.177 306.842 267.859 308.567C266.497 310.291 265.225 312.06 264.044 313.921C261.636 317.551 259.455 321.362 257.411 325.219C253.323 332.933 249.597 340.828 246.009 348.723C242.374 356.618 238.876 364.604 235.333 372.544L214.027 420.187L171.28 515.383L172.915 516.109L215.345 420.732L236.56 373.043C240.103 365.103 243.601 357.117 247.19 349.222C250.779 341.327 254.458 333.432 258.501 325.763C260.546 321.952 262.681 318.141 265.043 314.556C266.224 312.741 267.496 310.971 268.813 309.293C270.131 307.614 271.539 305.98 273.084 304.483C276.127 301.488 279.671 298.993 283.668 297.541C287.666 296.089 291.982 295.68 296.252 295.998C298.387 296.134 300.522 296.452 302.612 296.86C304.747 297.268 306.837 297.767 308.926 298.312C313.106 299.446 317.194 300.853 321.283 302.35C329.414 305.345 337.41 308.748 345.359 312.196C353.309 315.645 361.259 319.184 369.209 322.723L393.013 333.341L440.667 354.576L631.146 439.381L678.755 460.57C686.704 464.11 694.609 467.649 702.604 471.097C710.6 474.546 718.595 477.949 726.772 480.898C730.86 482.396 734.994 483.711 739.219 484.8C743.444 485.889 747.714 486.706 752.075 486.842C756.436 487.024 760.843 486.388 764.84 484.664C768.838 482.94 772.381 480.218 775.334 477.041C778.333 473.865 780.877 470.326 783.193 466.651C785.51 462.975 787.645 459.164 789.644 455.307C793.778 447.639 797.412 439.744 801.001 431.849Z"
          fill="#919191"
        />
        <path
          d="M800.818 458.483C798.956 462.249 797.003 465.97 794.958 469.645C792.914 473.321 790.688 476.905 788.235 480.308C785.782 483.711 783.011 486.933 779.785 489.61C776.56 492.287 772.79 494.284 768.701 495.282C764.612 496.28 760.388 496.28 756.208 495.781C752.029 495.282 747.94 494.284 743.943 493.104C735.902 490.699 728.088 487.614 720.366 484.392C712.643 481.17 704.966 477.767 697.288 474.319L674.302 464.019L628.374 443.464L444.709 361.11L398.782 340.555C383.473 333.704 368.209 326.807 352.809 320.046C345.132 316.689 337.409 313.422 329.504 310.472C325.552 309.02 321.554 307.659 317.511 306.525C313.468 305.39 309.289 304.483 305.064 304.12C300.839 303.757 296.478 303.984 292.39 305.254C290.346 305.889 288.347 306.797 286.53 307.886C284.667 308.975 282.986 310.291 281.396 311.743C278.216 314.601 275.581 317.959 273.128 321.407C270.721 324.901 268.586 328.531 266.541 332.207C262.498 339.603 258.864 347.18 255.366 354.803C251.823 362.426 248.416 370.094 245.009 377.762L224.43 423.817L183.227 515.746L184.862 516.472L225.838 424.407L246.326 378.398C249.733 370.729 253.14 363.061 256.638 355.438C260.136 347.815 263.725 340.238 267.722 332.887C269.721 329.212 271.856 325.627 274.219 322.179C276.581 318.776 279.17 315.463 282.259 312.696C285.303 309.928 288.846 307.704 292.753 306.479C296.66 305.254 300.839 305.027 304.973 305.345C309.107 305.708 313.196 306.57 317.193 307.659C321.191 308.793 325.189 310.109 329.096 311.561C336.955 314.465 344.677 317.732 352.355 321.044C367.709 327.76 383.018 334.611 398.373 341.418L444.346 361.881L628.238 443.737L674.211 464.2L697.197 474.41C704.875 477.813 712.552 481.216 720.275 484.437C728.043 487.659 735.811 490.744 743.897 493.104C747.94 494.284 752.029 495.236 756.208 495.736C760.388 496.235 764.658 496.189 768.746 495.236C772.835 494.238 776.651 492.196 779.876 489.519C783.102 486.842 785.873 483.621 788.326 480.218C790.779 476.814 792.959 473.23 795.004 469.555C797.003 466.015 798.956 462.249 800.818 458.483Z"
          fill="#919191"
        />
        <path
          d="M800.956 482.305C798.866 485.753 796.64 489.156 794.096 492.332C791.552 495.463 788.69 498.413 785.328 500.681C781.967 502.95 778.105 504.402 774.108 505.037C770.11 505.627 766.022 505.355 762.024 504.72C754.029 503.404 746.351 500.681 738.765 497.823C731.178 494.919 723.774 491.697 716.324 488.476C701.469 481.942 686.705 475.272 671.895 468.647L627.512 448.773L449.934 369.187L405.551 349.313C390.742 342.688 375.978 336.018 361.123 329.484C353.673 326.263 346.222 323.041 338.636 320.182C334.82 318.776 331.004 317.415 327.097 316.28C323.191 315.146 319.193 314.193 315.15 313.648C313.106 313.376 311.061 313.24 309.017 313.285C306.973 313.331 304.883 313.512 302.884 313.966C298.841 314.828 294.98 316.643 291.709 319.184C288.438 321.725 285.622 324.811 283.169 328.032C280.715 331.299 278.49 334.747 276.445 338.287C272.357 345.365 268.813 352.67 265.361 360.021C261.908 367.372 258.592 374.768 255.276 382.209L235.378 426.676L195.447 515.564L197.083 516.29L236.696 427.311L256.502 382.799C259.819 375.403 263.089 367.961 266.542 360.611C269.994 353.26 273.538 345.955 277.536 338.967C279.534 335.473 281.715 332.07 284.123 328.849C286.53 325.627 289.256 322.633 292.39 320.228C295.525 317.777 299.159 316.053 303.066 315.237C305.019 314.828 306.973 314.601 308.972 314.556C310.97 314.511 312.969 314.647 314.968 314.919C318.966 315.418 322.873 316.371 326.734 317.46C330.595 318.594 334.411 319.91 338.227 321.317C345.814 324.13 353.264 327.306 360.714 330.528C375.569 337.016 390.378 343.641 405.188 350.22L449.616 370.003L627.376 449.136L671.804 468.919C686.614 475.499 701.423 482.123 716.278 488.657C723.728 491.879 731.178 495.1 738.765 497.959C746.351 500.817 754.029 503.495 762.069 504.81C766.067 505.446 770.156 505.673 774.199 505.083C778.196 504.493 782.103 502.995 785.465 500.727C788.826 498.413 791.688 495.509 794.232 492.332C796.64 489.202 798.866 485.799 800.956 482.305Z"
          fill="#919191"
        />
        <path
          d="M800.911 503.086C798.321 506.036 795.414 508.758 792.052 510.8C791.189 511.254 790.371 511.798 789.463 512.161C789.009 512.343 788.6 512.569 788.1 512.751L786.737 513.25C784.875 513.84 782.967 514.294 781.013 514.475C777.106 514.929 773.154 514.566 769.293 513.931C765.431 513.25 761.616 512.252 757.89 511.072C754.165 509.892 750.44 508.577 746.761 507.17C743.081 505.763 739.447 504.266 735.858 502.769C728.635 499.729 721.457 496.552 714.28 493.331L628.239 454.808L456.204 377.717L413.184 358.433C398.828 352.035 384.519 345.547 370.163 339.24C362.94 336.109 355.717 332.978 348.403 330.165C344.724 328.758 341.044 327.442 337.274 326.263C333.503 325.083 329.687 324.039 325.78 323.359C323.827 322.996 321.874 322.769 319.875 322.633C317.876 322.496 315.877 322.542 313.878 322.723C309.881 323.132 305.974 324.357 302.521 326.444C299.069 328.531 296.071 331.254 293.481 334.248C290.892 337.243 288.62 340.51 286.531 343.868C284.441 347.225 282.488 350.674 280.67 354.168C278.853 357.662 277.082 361.201 275.355 364.74C271.948 371.818 268.678 378.987 265.452 386.157L246.191 429.217L207.622 515.428L209.258 516.154L247.599 429.943L266.77 386.837C269.995 379.668 273.22 372.499 276.582 365.421C278.263 361.881 279.989 358.342 281.852 354.894C283.669 351.4 285.577 347.997 287.621 344.685C289.665 341.372 291.891 338.151 294.435 335.201C296.934 332.252 299.841 329.62 303.112 327.624C306.383 325.627 310.108 324.448 313.924 324.039C315.832 323.812 317.785 323.812 319.693 323.903C321.601 324.039 323.554 324.221 325.462 324.584C329.278 325.219 333.049 326.263 336.819 327.397C340.544 328.577 344.224 329.892 347.904 331.254C355.218 334.067 362.441 337.107 369.664 340.238C384.064 346.499 398.374 352.943 412.729 359.34L455.795 378.488L628.012 455.126L714.143 493.558C721.321 496.734 728.499 499.91 735.767 502.905C739.401 504.402 743.036 505.899 746.715 507.306C750.395 508.713 754.074 510.028 757.845 511.208C761.616 512.388 765.386 513.386 769.293 514.021C773.154 514.657 777.106 515.02 781.013 514.566C782.967 514.384 784.875 513.931 786.783 513.341L788.145 512.842C788.6 512.66 789.054 512.433 789.508 512.252C790.417 511.889 791.235 511.344 792.098 510.891C795.459 508.758 798.367 506.036 800.911 503.086Z"
          fill="#919191"
        />
        <path
          d="M755.755 516.925C749.077 514.384 742.49 511.617 735.948 508.758C729.407 505.899 722.865 502.995 716.369 500.092L677.256 482.577L599.029 447.548L442.621 377.445L403.507 359.93L383.928 351.173C377.386 348.269 370.845 345.41 364.257 342.688C357.625 339.966 350.947 337.379 344.088 335.247C340.635 334.203 337.182 333.296 333.639 332.66C331.867 332.343 330.05 332.116 328.279 331.98C326.461 331.844 324.644 331.844 322.827 331.98C319.193 332.252 315.559 333.114 312.333 334.793C309.063 336.426 306.155 338.695 303.611 341.281C301.067 343.868 298.841 346.726 296.797 349.721C294.753 352.67 292.89 355.756 291.164 358.887C287.666 365.148 284.532 371.591 281.442 378.08C278.399 384.568 275.446 391.057 272.539 397.591L255.003 436.749L219.933 515.065L221.569 515.791L256.412 437.384L273.811 398.181C276.718 391.647 279.625 385.113 282.669 378.67C285.713 372.227 288.802 365.784 292.3 359.567C294.026 356.482 295.843 353.396 297.842 350.492C299.841 347.588 302.021 344.73 304.474 342.234C306.927 339.739 309.699 337.515 312.833 335.973C315.922 334.384 319.375 333.522 322.873 333.25C324.599 333.114 326.371 333.114 328.142 333.25C329.914 333.386 331.64 333.568 333.412 333.885C336.91 334.475 340.362 335.383 343.724 336.381C350.538 338.468 357.171 341.009 363.803 343.732C370.39 346.454 376.932 349.267 383.473 352.171L403.053 360.838L442.212 378.261L598.847 447.956L677.165 482.804L716.324 500.228C722.865 503.132 729.361 506.036 735.948 508.849C742.49 511.662 749.077 514.43 755.755 516.925Z"
          fill="#919191"
        />
        <path
          d="M740.128 516.472L721.548 508.213L703.013 499.91L665.944 483.303L591.806 450.044L443.484 383.57L406.415 366.963C400.237 364.195 394.058 361.428 387.835 358.705C381.611 355.983 375.433 353.306 369.118 350.765C362.849 348.224 356.444 345.864 349.902 343.959C346.632 343.051 343.315 342.234 339.908 341.735C336.547 341.236 333.049 341.055 329.642 341.418C326.189 341.781 322.827 342.779 319.738 344.367C318.194 345.184 316.74 346.136 315.377 347.18C314.014 348.269 312.697 349.403 311.516 350.629C309.108 353.079 306.973 355.801 305.02 358.569C303.066 361.382 301.295 364.286 299.614 367.236C296.252 373.134 293.208 379.26 290.301 385.385C287.394 391.511 284.577 397.682 281.806 403.853L265.179 440.969L231.972 515.247L233.607 515.973L266.679 441.649L283.169 404.488C285.94 398.317 288.711 392.101 291.618 386.02C294.526 379.895 297.524 373.815 300.84 367.962C302.521 365.012 304.247 362.154 306.155 359.386C308.063 356.618 310.108 353.941 312.47 351.581C313.606 350.356 314.878 349.267 316.195 348.269C317.512 347.271 318.921 346.363 320.374 345.592C323.282 344.049 326.507 343.096 329.823 342.733C333.14 342.37 336.501 342.552 339.772 343.006C343.088 343.459 346.359 344.231 349.63 345.138C356.126 346.953 362.441 349.313 368.71 351.854C374.979 354.349 381.202 357.026 387.426 359.749C393.649 362.471 399.828 365.194 406.006 367.962L443.12 384.478L591.624 450.543L665.853 483.575L702.968 500.091L721.548 508.35L740.128 516.472Z"
          fill="#919191"
        />
        <path
          d="M728.816 517.243L446.527 390.694L411.23 374.858C405.324 372.227 399.464 369.595 393.558 367.009C387.653 364.422 381.702 361.881 375.705 359.477C369.709 357.117 363.621 354.848 357.398 353.079C354.263 352.217 351.129 351.445 347.903 350.992C344.678 350.538 341.407 350.311 338.136 350.629C334.865 350.901 331.595 351.763 328.642 353.169C325.644 354.576 322.963 356.573 320.601 358.796C318.239 361.065 316.104 363.56 314.196 366.192C312.288 368.824 310.516 371.546 308.881 374.359C305.564 379.94 302.657 385.703 299.841 391.511C297.024 397.319 294.344 403.172 291.663 409.071L275.764 444.463L244.146 515.11L245.781 515.836L277.217 445.098L292.935 409.751C295.57 403.853 298.251 397.999 301.067 392.191C303.838 386.383 306.791 380.666 310.016 375.085C311.652 372.317 313.378 369.595 315.241 367.009C317.103 364.422 319.147 361.972 321.464 359.794C323.781 357.616 326.325 355.71 329.187 354.349C332.003 352.988 335.093 352.171 338.272 351.899C341.407 351.581 344.632 351.808 347.767 352.217C350.901 352.67 354.036 353.396 357.125 354.213C363.303 355.937 369.345 358.161 375.342 360.52C381.338 362.88 387.244 365.421 393.149 367.962C399.055 370.548 404.961 373.134 410.821 375.766L446.164 391.465L728.816 517.243Z"
          fill="#919191"
        />
        <path
          d="M715.052 516.835L448.027 397.092L414.637 382.118C409.049 379.623 403.507 377.173 397.92 374.722C392.332 372.317 386.699 369.913 381.02 367.735C375.342 365.557 369.573 363.469 363.622 361.927C360.669 361.155 357.625 360.52 354.581 360.157C351.538 359.794 348.403 359.703 345.314 360.066C342.225 360.429 339.181 361.292 336.365 362.698C333.548 364.059 331.004 365.92 328.733 368.052C326.462 370.14 324.463 372.544 322.6 374.995C320.738 377.445 319.057 380.031 317.467 382.663C314.287 387.926 311.47 393.371 308.745 398.816C306.064 404.306 303.475 409.842 300.931 415.378C295.889 426.494 290.937 437.656 285.94 448.773L256.048 515.61L257.684 516.336L287.394 449.408C292.345 438.246 297.251 427.084 302.294 415.968C304.793 410.432 307.336 404.851 310.017 399.406C312.697 393.961 315.468 388.516 318.603 383.298C320.147 380.712 321.828 378.171 323.645 375.721C325.462 373.316 327.416 371.002 329.596 368.914C331.777 366.873 334.184 365.058 336.865 363.742C339.545 362.38 342.452 361.609 345.405 361.246C348.358 360.883 351.401 360.974 354.4 361.337C357.398 361.7 360.351 362.29 363.304 363.061C369.164 364.558 374.933 366.6 380.612 368.778C386.29 370.956 391.923 373.316 397.511 375.721C403.098 378.125 408.686 380.576 414.274 383.071L447.709 397.909L715.052 516.835Z"
          fill="#919191"
        />
        <path
          d="M702.468 516.971L450.298 403.853L418.771 389.741C413.502 387.382 408.232 385.068 402.962 382.799C397.647 380.53 392.332 378.307 386.926 376.265C381.52 374.223 376.069 372.363 370.436 370.956C367.619 370.276 364.757 369.686 361.85 369.414C358.943 369.096 355.99 369.051 353.082 369.414C350.175 369.777 347.268 370.548 344.633 371.818C341.953 373.089 339.5 374.768 337.319 376.719C332.958 380.621 329.505 385.385 326.416 390.286C323.327 395.186 320.602 400.313 318.012 405.441C315.423 410.613 312.97 415.831 310.562 421.049C305.747 431.531 301.113 442.058 296.343 452.585L268.087 515.746L269.722 516.472L297.797 453.265C302.476 442.738 307.109 432.166 311.879 421.685C314.287 416.467 316.695 411.249 319.284 406.076C321.874 400.949 324.554 395.867 327.552 390.966C330.596 386.111 333.957 381.438 338.182 377.626C340.272 375.721 342.634 374.132 345.133 372.907C347.677 371.682 350.402 370.956 353.219 370.548C358.852 369.867 364.576 370.684 370.118 372.045C375.66 373.406 381.111 375.267 386.517 377.263C391.878 379.26 397.193 381.483 402.508 383.706C407.823 385.93 413.093 388.244 418.362 390.603L449.935 404.624L702.468 516.971Z"
          fill="#919191"
        />
        <path
          d="M690.203 517.243L452.842 410.75L423.132 397.455C413.229 393.054 403.28 388.698 393.104 384.932C388.016 383.071 382.837 381.302 377.522 380.076C372.207 378.851 366.71 378.08 361.214 378.67C358.488 378.987 355.762 379.713 353.218 380.848C350.674 381.982 348.358 383.525 346.223 385.249C341.952 388.788 338.591 393.19 335.592 397.772C332.594 402.355 329.959 407.12 327.461 411.929C324.962 416.739 322.6 421.639 320.329 426.585C315.74 436.431 311.334 446.368 306.927 456.26L280.261 515.655L281.897 516.381L308.336 456.895C312.742 446.958 317.103 437.021 321.646 427.22C323.917 422.32 326.234 417.42 328.733 412.61C331.186 407.8 333.821 403.036 336.728 398.544C339.681 394.052 342.952 389.741 347.04 386.293C349.084 384.569 351.31 383.117 353.718 382.028C356.126 380.984 358.715 380.258 361.35 379.94C366.62 379.305 372.026 380.076 377.25 381.256C382.474 382.481 387.653 384.16 392.695 386.021C402.826 389.741 412.774 394.097 422.723 398.408L452.433 411.566L690.203 517.243Z"
          fill="#919191"
        />
        <path
          d="M677.392 517.243L455.386 417.601C446.119 413.472 436.897 409.298 427.63 405.214C418.362 401.13 409.05 397.092 399.464 393.643C394.694 391.919 389.834 390.376 384.837 389.242C379.885 388.153 374.706 387.427 369.573 387.972C366.983 388.244 364.44 388.834 362.032 389.832C359.624 390.785 357.353 392.146 355.309 393.689C351.175 396.82 347.858 400.858 344.951 405.032C342.044 409.252 339.454 413.653 337.047 418.146C334.639 422.638 332.367 427.175 330.187 431.758C325.826 440.923 321.692 450.225 317.513 459.482L292.663 515.02L294.299 515.746L319.012 460.071C323.146 450.815 327.234 441.513 331.55 432.348C333.73 427.765 335.956 423.227 338.318 418.735C340.681 414.289 343.225 409.887 346.087 405.758C348.949 401.629 352.174 397.682 356.126 394.687C358.08 393.19 360.26 391.919 362.532 390.966C364.803 390.013 367.256 389.424 369.709 389.197C374.661 388.652 379.703 389.333 384.609 390.376C389.516 391.465 394.331 393.008 399.101 394.687C408.641 398.09 417.954 402.083 427.221 406.121C436.488 410.16 445.755 414.289 455.023 418.418L677.392 517.243Z"
          fill="#919191"
        />
        <path
          d="M663.945 517.016L457.067 424.135C448.436 420.278 439.85 416.376 431.173 412.61C422.496 408.844 413.774 405.123 404.825 402.038C402.599 401.266 400.327 400.54 398.056 399.905C395.785 399.224 393.468 398.635 391.151 398.181C386.472 397.228 381.657 396.729 376.887 397.319C374.479 397.636 372.117 398.226 369.891 399.134C367.665 400.041 365.53 401.266 363.622 402.718C359.76 405.622 356.58 409.298 353.764 413.109C352.356 415.06 351.084 417.057 349.812 419.053C348.585 421.095 347.359 423.137 346.223 425.224C343.906 429.398 341.771 433.618 339.727 437.883C335.593 446.414 331.686 455.035 327.825 463.656L304.611 515.428L306.246 516.154L329.233 464.291C333.094 455.67 336.91 447.004 340.999 438.519C343.043 434.253 345.178 430.034 347.404 425.905C348.54 423.817 349.721 421.821 350.947 419.779C352.174 417.783 353.446 415.831 354.809 413.926C357.534 410.16 360.623 406.575 364.349 403.762C366.211 402.355 368.21 401.221 370.345 400.313C372.48 399.451 374.706 398.861 377.023 398.544C381.611 397.954 386.336 398.453 390.924 399.315C393.241 399.769 395.512 400.313 397.738 400.994C400.009 401.629 402.235 402.355 404.461 403.081C413.365 406.121 422.087 409.797 430.764 413.517C439.441 417.238 448.072 421.095 456.703 424.952L663.945 517.016Z"
          fill="#919191"
        />
        <path
          d="M650.135 516.562L458.793 430.623C450.798 427.039 442.848 423.454 434.807 420.006C426.766 416.557 418.68 413.2 410.321 410.477C409.277 410.114 408.232 409.842 407.187 409.479C406.142 409.161 405.097 408.844 404.007 408.572C401.872 407.982 399.737 407.528 397.556 407.12C393.241 406.348 388.743 405.985 384.337 406.62C382.111 406.938 379.93 407.483 377.886 408.345C375.796 409.161 373.843 410.296 372.026 411.566C370.209 412.882 368.528 414.334 366.983 415.922C365.439 417.51 364.03 419.234 362.668 420.959C359.987 424.498 357.671 428.219 355.49 432.03C353.309 435.841 351.265 439.744 349.312 443.646C345.405 451.496 341.771 459.436 338.137 467.422L316.695 515.428L318.33 516.154L339.59 468.148C343.179 460.162 346.768 452.176 350.629 444.372C352.583 440.47 354.581 436.567 356.717 432.801C358.852 429.035 361.168 425.315 363.758 421.866C365.075 420.142 366.438 418.463 367.937 416.92C369.436 415.378 371.026 413.926 372.753 412.701C374.479 411.43 376.341 410.386 378.34 409.57C380.294 408.753 382.383 408.209 384.518 407.891C388.743 407.256 393.104 407.573 397.374 408.345C399.51 408.708 401.645 409.161 403.734 409.751C404.779 410.023 405.824 410.341 406.869 410.613C407.914 410.931 408.959 411.249 410.003 411.566C418.271 414.243 426.357 417.556 434.398 420.959C442.439 424.362 450.434 427.901 458.43 431.44L650.135 516.562Z"
          fill="#919191"
        />
        <path
          d="M637.279 516.562L461.019 437.384C453.66 434.117 446.3 430.85 438.896 427.719C431.446 424.589 423.995 421.594 416.273 419.189C412.411 418.009 408.504 416.966 404.461 416.331C402.463 416.013 400.418 415.786 398.374 415.695C396.33 415.65 394.286 415.695 392.241 416.013C390.197 416.285 388.198 416.83 386.29 417.556C384.382 418.282 382.52 419.28 380.839 420.414C377.432 422.683 374.479 425.632 371.935 428.808C370.618 430.397 369.482 432.03 368.301 433.709C367.165 435.388 366.075 437.112 365.03 438.836C362.94 442.285 360.987 445.869 359.17 449.454C355.49 456.623 352.083 463.974 348.721 471.279C345.36 478.629 342.089 485.98 338.818 493.331L328.869 515.337L330.505 516.063L340.272 493.966C343.543 486.615 346.768 479.219 350.084 471.869C353.4 464.518 356.762 457.213 360.396 450.044C362.213 446.459 364.121 442.92 366.166 439.471C367.165 437.747 368.255 436.068 369.391 434.39C370.527 432.756 371.663 431.123 372.934 429.58C375.433 426.494 378.25 423.636 381.52 421.412C383.156 420.323 384.882 419.371 386.745 418.645C388.562 417.919 390.47 417.465 392.423 417.147C394.376 416.875 396.33 416.784 398.329 416.83C400.327 416.875 402.281 417.102 404.28 417.42C408.232 418.055 412.093 419.053 415.955 420.187C423.632 422.547 431.082 425.496 438.532 428.582C445.937 431.667 453.342 434.889 460.701 438.156L637.279 516.562Z"
          fill="#919191"
        />
        <path
          d="M624.286 516.517L463.108 444.054C456.385 441.06 449.616 438.11 442.802 435.297C435.988 432.529 429.083 429.852 421.996 427.765C418.453 426.721 414.819 425.859 411.139 425.36C409.276 425.088 407.414 424.952 405.551 424.906C403.689 424.861 401.826 424.997 399.964 425.269C398.101 425.541 396.284 425.995 394.512 426.676C392.741 427.356 391.06 428.173 389.47 429.171C387.88 430.17 386.381 431.349 384.973 432.575C384.246 433.21 383.61 433.845 382.928 434.526C382.61 434.843 382.292 435.206 381.974 435.569C381.656 435.887 381.338 436.25 381.066 436.613C379.839 438.019 378.703 439.517 377.613 441.014C376.523 442.511 375.478 444.054 374.479 445.642C372.48 448.773 370.663 451.995 368.891 455.262C365.393 461.796 362.213 468.42 359.079 475.136C355.99 481.806 352.946 488.566 349.948 495.282L340.907 515.473L342.543 516.199L351.492 495.962C354.49 489.202 357.443 482.486 360.532 475.771C363.621 469.101 366.756 462.431 370.208 455.942C371.935 452.721 373.752 449.499 375.66 446.414C376.614 444.871 377.659 443.328 378.703 441.831C379.794 440.379 380.884 438.882 382.065 437.52C382.338 437.157 382.656 436.84 382.974 436.477C383.292 436.159 383.564 435.796 383.882 435.478C384.518 434.843 385.154 434.208 385.836 433.573C387.198 432.348 388.607 431.213 390.106 430.26C391.605 429.308 393.24 428.491 394.921 427.856C396.602 427.22 398.374 426.767 400.145 426.494C401.917 426.222 403.734 426.086 405.551 426.131C407.368 426.131 409.186 426.267 411.003 426.54C414.637 426.993 418.18 427.856 421.724 428.854C428.765 430.85 435.67 433.482 442.484 436.25C449.298 439.018 456.067 441.922 462.79 444.871L624.286 516.517Z"
          fill="#919191"
        />
        <path
          d="M611.839 516.698L538.655 483.757L502.04 467.286C489.82 461.796 477.645 456.26 465.425 450.86C459.292 448.183 453.16 445.506 446.936 443.056C440.712 440.606 434.398 438.246 427.902 436.522C424.631 435.66 421.36 434.934 417.998 434.526C414.637 434.163 411.23 434.072 407.823 434.616C404.461 435.115 401.145 436.295 398.192 438.019C396.738 438.882 395.284 439.88 394.012 440.969C393.694 441.241 393.377 441.513 393.059 441.786C392.741 442.058 392.423 442.33 392.105 442.648C391.514 443.237 390.878 443.827 390.333 444.463C388.016 446.958 385.972 449.635 384.064 452.448C382.156 455.262 380.43 458.12 378.794 461.07C375.478 466.923 372.525 472.958 369.618 478.992C363.848 491.153 358.442 503.404 352.946 515.61L354.581 516.335C359.987 504.084 365.347 491.788 370.981 479.673C373.843 473.638 376.75 467.603 379.975 461.796C381.611 458.892 383.292 456.033 385.154 453.265C387.017 450.497 389.015 447.866 391.241 445.415C391.787 444.78 392.377 444.236 392.968 443.646C393.286 443.374 393.558 443.101 393.876 442.829C394.194 442.557 394.467 442.285 394.785 442.012C396.011 440.923 397.374 440.016 398.782 439.154C400.191 438.292 401.69 437.611 403.189 437.067C404.733 436.477 406.323 436.114 407.913 435.841C411.139 435.297 414.455 435.388 417.726 435.705C420.997 436.068 424.267 436.749 427.493 437.611C433.944 439.29 440.213 441.604 446.436 444.009C452.66 446.459 458.793 449.045 464.925 451.722C477.191 457.031 489.411 462.522 501.631 467.921L538.337 484.165L611.839 516.698Z"
          fill="#919191"
        />
        <path
          d="M598.483 516.517L532.159 486.661L498.996 471.733C487.957 466.787 476.918 461.75 465.743 456.941C460.155 454.536 454.568 452.222 448.844 450.134C443.165 448.002 437.351 446.096 431.399 444.826C428.401 444.19 425.358 443.737 422.314 443.646L421.178 443.6C420.815 443.6 420.406 443.6 420.042 443.6C419.27 443.6 418.498 443.691 417.726 443.737C416.181 443.918 414.637 444.1 413.137 444.508L412.592 444.644L412.047 444.826C411.684 444.962 411.32 445.052 410.957 445.189C410.23 445.461 409.503 445.733 408.822 446.051C407.414 446.686 406.051 447.457 404.779 448.319C402.189 450.044 399.918 452.131 397.828 454.445C393.694 459.028 390.424 464.2 387.38 469.464C384.336 474.773 381.611 480.172 378.976 485.662C373.706 496.598 368.754 507.714 363.803 518.786L365.438 519.512C370.344 508.395 375.205 497.278 380.384 486.343C382.973 480.898 385.699 475.453 388.652 470.19C391.65 464.926 394.875 459.799 398.828 455.352C400.827 453.129 403.007 451.087 405.46 449.408C406.687 448.592 407.959 447.82 409.322 447.23C410.003 446.913 410.684 446.641 411.366 446.368C411.729 446.232 412.047 446.141 412.411 446.005L412.956 445.824L413.501 445.688C414.909 445.279 416.408 445.052 417.862 444.916C418.589 444.871 419.361 444.78 420.088 444.78C420.451 444.78 420.815 444.735 421.224 444.735H422.359C425.358 444.826 428.31 445.234 431.263 445.824C437.169 447.049 442.938 448.909 448.617 450.951C454.295 453.038 459.928 455.307 465.516 457.667C476.691 462.385 487.73 467.331 498.86 472.232L532.113 486.978L598.483 516.517Z"
          fill="#919191"
        />
      </g>
      <rect
        width="1031"
        height="467"
        rx="6"
        transform="matrix(-1 0 0 1 1031 0)"
        fill="url(#paint0_linear_0_488)"
      />
      <defs>
        <linearGradient
          id="paint0_linear_0_488"
          x1="756.57"
          y1="6.38175e-05"
          x2="554.541"
          y2="232.885"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="currentColor" />
          <stop offset="1" stopColor="currentColor" stopOpacity="0" />
        </linearGradient>
        <clipPath id="clip0_0_488">
          <rect
            width="802"
            height="414"
            fill="white"
            transform="matrix(1 0 0 -1 0 467)"
          />
        </clipPath>
      </defs>
    </svg>
  );
};
